<?php
namespace YES4Trade\Model;

class groups_characteristic_set_description extends \YES4Trade\Model\BaseType{
    const TABLE_NAME = 'products_characteristic_set_description';
    const TABLE_INDEX = 'products_characteristic_set_description';
    private static $propertyTypes = [
        'products_characteristic_set_description_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'products_characteristic_set_description_id'
        ],
        'products_characteristic_set_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'products_characteristic_set_id'
        ],
        'title' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'title'
        ],
        'language_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'language_id'
        ],
    ];
    
    public function __construct( array $values = [] ){
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);

        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }

        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }

        $this->setValues(__CLASS__, $childValues);
    }

    public function create(){
        $data = $this->toArray();
        unset($data['description']);
        xtc_db_perform(self::TABLE_NAME, $data);
        \YES4Trade\Model\group_handler::clear_cache();
        return xtc_db_insert_id();
    }
    
    public function update(){
        $data = $this->toArray();
        unset($data[self::TABLE_INDEX]);
        unset($data['products_characteristic_set_description_id']);
        unset($data['description']);
        $index = self::TABLE_INDEX;
        xtc_db_perform(self::TABLE_NAME, $data,'update',self::TABLE_INDEX."='".$this->products_characteristic_set_description_id."'");
        \YES4Trade\Model\group_handler::clear_cache();
    }
    
    public static function delete( int $index ){
        xtc_db_query(sprintf(
                "DELETE FROM %s WHERE %s='%d'",
                self::TABLE_NAME,self::TABLE_INDEX, $index
        ));
        \YES4Trade\Model\group_handler::clear_cache();
    }
    
    public static function get_by_characteristic_set_id( int $characteristic_set_id, int $language_id = -1 ){
        $items = [];
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE products_characteristic_set_id=:id",
                self::TABLE_NAME, 
            ),['id'=>$characteristic_set_id]
        );
        foreach($query as $record){
            foreach($record as $k=>$v){
                switch($k){
                    case 'title':
                        break;
                    case 'products_characteristic_set_description':
                        unset($record['products_characteristic_set_description']);
                        $record['products_characteristic_set_description_id'] = (int)$v;
                        break;
                    default:
                        $record[$k] = (int)$v;
                        break;
                }
            }
            if($language_id > -1){
                if($language_id == $record['language_id']){
                    return new \YES4Trade\Model\groups_characteristic_set_description($record);
                }
            }else{
                $items[] = new \YES4Trade\Model\groups_characteristic_set_description($record);
            }
        }
        return $items;
    }
}