<?php
namespace YES4Trade\Model;

class group_prices {
    var $customers_status_id;
    
    
    public function __construct(){
        
    }
    
    public static function get_table_name( int $customers_status_id ){
        return 'personal_offers_by_customers_status_'.$customers_status_id;
    }
    
    public static function get_items_by_products_id( int $customers_status_id, int $products_id ){
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE products_id =:products_id ORDER BY quantity ASC",
                self::get_table_name($customers_status_id),
            ),['products_id'=>$products_id]
        );
        $items = [];
        foreach($query as $record){
            $record['personal_offer'] = (float)$record['personal_offer'];
            $record['price_id'] = (int)$record['price_id'];
            $record['products_id'] = (int)$record['products_id'];
            $record['quantity'] = (int)$record['quantity'];
            $items[] = new \YES4Trade\Model\group_prices_item( $record );
        }
        return $items;
    }
    
    public static function delete_cache_by_products_id( int $customers_status_id, int $products_id ){
        global $InstanceCache;
        foreach($InstanceCache->getItemsByTags(['admin','shop']) as $cn=>$cd){
            if(strpos($cd->getKey(),'group_prices_'.$customers_status_id.'_'.$products_id)>-1){
                $InstanceCache->deleteItem($cd->getKey()); // group_prices_*
            }
        }
    }
    
    public static function delete_by_products_id( int $customers_status_id, int $products_id ){
        if( $products_id < 1 ){
            throw new \LogicException(__CLASS__.'::'.__FUNCTION__.' products_id invalid');
        }
        yes_query(sprintf(
            "DELETE FROM %s WHERE products_id=:products_id",
                self::get_table_name($customers_status_id)
            ),['products_id'=>$products_id]
        );
    }
    
    public static function truncate_table( int $customers_status_id ){
        xtc_db_query(sprintf(
            "TRUNCATE %s",
            self::get_table_name($customers_status_id)
        ));
    }
    
    public static function create_table( int $customers_status_id ){
        xtc_db_query(sprintf(
            "create table %s (price_id INT NOT NULL AUTO_INCREMENT PRIMARY KEY, products_id int NOT NULL, quantity int, personal_offer decimal(15,4))",
            self::get_table_name($customers_status_id)
        ));
        xtc_db_query(sprintf(
            "ALTER TABLE %s ADD INDEX (  `products_id` )",
            self::get_table_name($customers_status_id)
        ));
    }
    
    public static function drop_table( int $customers_status_id ){
        xtc_db_query(sprintf(
            "drop table IF EXISTS %s",
            self::get_table_name($customers_status_id)
        ));
    }
}
