<?php

namespace YES4Trade\Model;

class ebay_sites extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'ebay_sites';
    const TABLE_INDEX = 'id';
    
    private static $propertyTypes = [
        'id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'id'
        ],
        'site_name' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'site_name'
        ],
    ];


    public function __construct(array $values = []) {
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);

        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }

        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }

        $this->setValues(__CLASS__, $childValues);
    }


    public function create() {
        $data = $this->toArray();
        unset($data['id']);
        yes_db_perform(self::TABLE_NAME, $data);
        return xtc_db_insert_id();
    }


    public function update() {
        $data = $this->toArray();
        $data['id'] = (int)$data['ebay_variations_id'];
        unset($data[self::TABLE_INDEX]);
        
        $index = self::TABLE_INDEX;
        yes_db_perform(self::TABLE_NAME, $data,'update',[
            $index=>$this->$index
        ]);
    }


    public static function delete(int $index) {
        yes_query(sprintf(
            "DELETE FROM %s WHERE %s=:id",
                self::TABLE_NAME,self::TABLE_INDEX
            ),['id'=>$index]
        );
    }


    public static function get_by_id(int $id) {
        $query = yes_query(sprintf(
            "SELECT id,site_name FROM %s WHERE %s=:id",
                self::TABLE_NAME, self::TABLE_INDEX
            ),['id'=>$id]
        );
        if(!sizeOf($query)){
            return null;
        }
        $record = current($query);
        foreach(get_class_vars(__CLASS__) as $pk=>$pv){
           if($pv['type'] == 'integer'){
               $record[$pk] = (int)$record[$pk];
           }
        }
        $item = new self($record);
        return $item;
    }

    public static function get_list(){
        $items = [];
        $query = xtc_db_query(sprintf(
            "SELECT id, site_name FROM %s ORDER BY site_name",
            self::TABLE_NAME
        ));
        while($record = xtc_db_fetch_array($query)){
            $items[] = new self($record);
        }
        return $items;
    }
}
