<?php
namespace YES4Trade\Model;
class ebay_products_responsible_persons extends \YES4Trade\Model\BaseType{
    const TABLE_NAME = 'ebay_products_responsible_persons';
    const TABLE_INDEX = 'ebay_products_responsible_persons_id';
    private static $propertyTypes = [
        'ebay_products_responsible_persons_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ebay_products_responsible_persons_id'
        ],
        'ebay_products_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ebay_products_id'
        ],
        'rp_cityname' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'rp_cityname'
        ],
        'rp_companyname' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'rp_companyname'
        ],
        'rp_country' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'rp_country'
        ],
        'rp_email' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'rp_email'
        ],
        'rp_phone' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'rp_phone'
        ],
        'rp_postalcode' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'rp_postalcode'
        ],
        'rp_stateorprovince' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'rp_stateorprovince'
        ],
        'rp_street1' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'rp_street1'
        ],
        'rp_street2' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'rp_street2'
        ],
    ];
    
    public function __construct( array $values = [] ){
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);

        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }

        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }

        $this->setValues(__CLASS__, $childValues);
    }
    
	public static function convertInt( array $data ){
		foreach(get_class_vars(__CLASS__) as $pk=>$pv){
		   if($pk == 'propertyTypes'){
		   	foreach($pv as $kpart => $part){
			   if($part['type'] == 'integer' and isset($data[$kpart])){
			       $data[$kpart] = (int)$data[$kpart];
			   }
		   	}
		   }
		}
		return $data;
	}
    
    public function create(){
        $data = $this->toArray();
        $data = self::convertInt($data);
        xtc_db_perform(self::TABLE_NAME, $data);
        return xtc_db_insert_id();
    }
    
    public function update(){
        $data = $this->toArray();
        $data = self::convertInt($data);
        unset($data[self::TABLE_INDEX]);
        $index = self::TABLE_INDEX;
        xtc_db_perform(self::TABLE_NAME, $data,'update',self::TABLE_INDEX."='".$this->$index."'");
    }
    
    public static function delete( int $index ){
        xtc_db_query(sprintf(
                "DELETE FROM %s WHERE %s='%d'",
                self::TABLE_NAME,self::TABLE_INDEX, $index
        ));
    }
    
    public static function get_by_ebay_products_id( int $ebay_products_id ){
        $items = [];
        $query = xtc_db_query(sprintf(
            "SELECT * FROM %s WHERE ebay_products_id='%d'",
            self::TABLE_NAME, $ebay_products_id
        ));
        while($record = xtc_db_fetch_array($query)){
            $record = self::convertInt($record);
            $items[] = new self($record);
        }
        return $items;
    }
    
    public static function get_by_ebay_products_responsible_persons_id( int $ebay_products_responsible_persons_id ){
        $query = xtc_db_query(sprintf(
            "SELECT * FROM %s WHERE %s='%d'",
            self::TABLE_NAME, self::TABLE_INDEX,$ebay_products_responsible_persons_id
        ));
        if(!xtc_db_num_rows($query)){
            return null;
        }
        $record = xtc_db_fetch_array($query);
        $record = self::convertInt($record);
        return new self($record);
    }
    
    public static function get_array_keys(){
        return get_class_vars(__CLASS__);
    }
}