<?php
namespace YES4Trade\Model;

class ebay_order_add_import extends \YES4Trade\Model\BaseType {
    private const JSON_SAVE_FILE_NAME = 'EBAY_ORDER_ADD_IMPORT.json';
    private static function get_file_path():string{
        return \main::get_importdata_path().self::JSON_SAVE_FILE_NAME;
    }

    public static function get():array{
        $file = self::get_file_path();
        if(!is_file($file)){
            return [];
        }
        return json_decode(file_get_contents($file),true);        
    }

    private static function exists(string $OrderID, string $seller, array $saved):bool{
        if(!isset($saved[$seller])){
            return false;
        }
        if(in_array($OrderID,$saved[$seller])){
            return true;
        }
        return false;
    }

    public static function add(string $OrderID, string $seller):void{
        $saved = self::get();
        if(self::exists($OrderID,$seller,$saved)){
            throw new Exception(sprintf(
                'Import for eBay Order %s (%s) exists.',
                $OrderID,$seller
            ));
        }
        if(isset($saved[$seller])){
            $saved[$seller][] = $OrderID;
        }else{
            if(sizeOf($saved) > 0){
                $saved[$seller] = [];
            }else{
                $saved = [
                    $seller => []
                ];
            }
            $saved[$seller][] = $OrderID;
        }
        file_put_contents(self::get_file_path(),json_encode($saved));
    }

    public static function isSaved(string $OrderID, string $seller):bool{
        $saved = self::get();
        return self::exists($OrderID,$seller,$saved);
    }

    public static function delete_processed( array $items, string $seller ){
        $saved = self::get();
        foreach($items as $OrderID){
            if(!self::exists($OrderID,$seller,$saved)){
                continue;
            }
            if(in_array($OrderID,$saved[$seller])){
                $new_arr = [];
                foreach($saved[$seller] as $_o){
                    if($_o == $OrderID){
                        continue;
                    }
                    $new_arr[] = $_o;
                }
                $saved[$seller] = $new_arr;
            }
        }
        if(isset($saved[$seller]) and is_countable($saved[$seller]) and !sizeOf($saved[$seller])){
            $saved[$seller] = null;
            unset($saved[$seller]);
        }
        if(!sizeOf($saved)){
            // wenn keine eintraege mehr vorhanden sind, auch keine anderer Seller
            // loeschen wir die import Datei
            unlink(self::get_file_path());
        }else{
            // es sind noch Eintraege vorhanden
            file_put_contents(self::get_file_path(),json_encode($saved));
        }
    }
}
