<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace YES4Trade\Model;
class amazon_feed_collector extends \YES4Trade\Model\BaseType{
    private static $propertyTypes = [
        'amazon_feed_collector_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'amazon_feed_collector_id'
        ],
        'selling_partner_id' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'selling_partner_id'
        ],
        'sku' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'sku'
        ],
        'feed_type' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'feed_type'
        ],
        'feed_value' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'feed_value'
        ],
        'fulfillment_latency' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'fulfillment_latency'
        ],
        'from_cron'=>[
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'from_fron'
        ],
        'date_added' => [
            'type' => 'datetime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'date_added'
        ],
    ];
    
    public function __construct( array $values = [] ){
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);

        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }

        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }

        $this->setValues(__CLASS__, $childValues);
    }
    
    public static function sku_exists( $sku, $feed_type = '' ){
        $feed_type_filter = (!empty($feed_type))?sprintf(" AND feed_type='%s'",$feed_type):'';
        $query = xtc_db_query(sprintf(
            "SELECT * FROM amazon_feed_collector WHERE sku='%s' %s",
            $sku, $feed_type_filter
        ));
        return (xtc_db_num_rows($query)>0)?true:false;
    }
    
    public static function delete_existing_before_add( $selling_partner_id, $sku, $feed_type ){
        xtc_db_query(sprintf(
            "DELETE FROM amazon_feed_collector WHERE selling_partner_id='%s' AND sku='%s' AND feed_type='%s'",
            $selling_partner_id, $sku, $feed_type
        ));
    }
    
    public static function delete_existing_before_add_not_cron( $selling_partner_id, $sku, $feed_type ){
        xtc_db_query(sprintf(
            "DELETE FROM amazon_feed_collector WHERE selling_partner_id='%s' AND sku='%s' AND feed_type='%s' AND from_cron=0",
            $selling_partner_id, $sku, $feed_type
        ));
    }
    
    public static function exists_from_cron( $selling_partner_id, $sku, $feed_type ){
        $query = xtc_db_query(sprintf(
            "SELECT * FROM amazon_feed_collector WHERE selling_partner_id='%s' AND sku='%s' AND feed_type='%s' AND from_cron=1",
            $selling_partner_id, $sku, $feed_type
        ));
        return (xtc_db_num_rows($query)>0) ? true : false;
    }
    
    public function create(){
        $data = $this->toArray();
        if(isset($data['amazon_feed_collector_id'])){
            $data['amazon_feed_collector_id'] = null;
            unset($data['amazon_feed_collector_id']);
        }
        if($data['from_cron'] == 1){
            self::delete_existing_before_add( $data['selling_partner_id'], $data['sku'], $data['feed_type'] );
        }else{
            if(self::exists_from_cron($data['selling_partner_id'], $data['sku'], $data['feed_type'])){
                return -1;
            }
            self::delete_existing_before_add_not_cron( $data['selling_partner_id'], $data['sku'], $data['feed_type'] );
        }
        $data['date_added'] = 'now()';
        xtc_db_perform('amazon_feed_collector', $data);
        return xtc_db_insert_id();
    }
    
    public static function delete( int $amazon_feed_collector_id ){
        xtc_db_query(sprintf(
                "DELETE FROM amazon_feed_collector WHERE amazon_feed_collector_id='%d'",
                $amazon_feed_collector_id
        ));
    }
    
    public static function get_list(){
        $return = [];
        $query = xtc_db_query(
            "SELECT * FROM amazon_feed_collector order by date_added"
        );
        while($record = xtc_db_fetch_array($query)){
            $return[] = $record;
        }
        return $return;
    }
}
