<?php
namespace YES4Trade\Enums;

/**
 * VERWENDUNG:
 * $pg = \YES4Trade\Enums\Packaging_Group::from('I');
*  echo $pg->label();
*
* ODER: 
* $pg = \YES4Trade\Enums\Packaging_Group::fromName('Packaging_Group_I');
* echo $pg->label();
*/

enum Packaging_Group: string
{

    case Packaging_Group_I = 'I';
    case Packaging_Group_II = 'II';
    case Packaging_Group_III = 'III';

    public function label(): string
    {
        return match($this) {
            self::Packaging_Group_I => constant('Packaging_Group_I'),
            self::Packaging_Group_II => constant('Packaging_Group_II'),
            self::Packaging_Group_III => constant('Packaging_Group_III'),
        };
    }

    public static function fromName(string $name): ?self
    {
        foreach (self::cases() as $case) {
            if ($case->name === $name) {
                return $case;
            }
        }
        return null;
    }

}
