<?php
$command_line = isset($argv[0]);
include('includes/application_top.php');
require_once(realpath(__DIR__).DIRECTORY_SEPARATOR.'includes/classes/class.ebay.php');
//require_once(realpath(__DIR__).DIRECTORY_SEPARATOR.'includes/classes/LMS.php');
$EBAYAPI = new \ebayAPI;
$ini_conf = ebayApi::get_ebay_config_ini();
$config = [
    'production'=>[
        'credentials' => [
            'devId' => $ini_conf['ebay-config']['dev-key-prod'],
            'appId' => $ini_conf['ebay-config']['app-key-prod'],
            'certId' => $ini_conf['ebay-config']['cert-id-prod'],
        ],
        'ruName'=>YES_UNIQUE_RUNAME
    ],
    'sandbox'=>[
        'credentials' => [
            'devId' => $ini_conf['ebay-config']['dev-key-test'],
            'appId' => $ini_conf['ebay-config']['app-key-test'],
            'certId' => $ini_conf['ebay-config']['cert-id-test'],
        ],
        'ruName'=>'agri_consulting-agricons-dccb-4-dttjfcj'
    ]
];
function myExcHandler($errorObj){
    yes_debug($errorObj);
	die(json_encode(array(
		'MSG'=>'Error Status Code '.$errorObj->getResponse()->getStatusCode().': '.$errorObj->getResponse()->getReasonPhrase()
	)));
}

function unzip($zipfile){
    $zip = new ZipArchive;
    $res = $zip->open($zipfile);
    if ($res === TRUE) {
      $filename = $zip->getNameIndex(0);
      $zip->extractTo(dirname($zipfile));
      $zip->close();
      return $filename;
    } else {
      echo 'doh!';
    }
}
$action = $_GET['action']??'';
$env = (main::isDev(true) === true or (defined('EBAY_TESTMODE') and EBAY_TESTMODE == '1')) ? 'sandbox' : 'production';
//$http_opts = (main::isDev(true))?['debug' => true]:[];
$http_opts = [];
$seller = $_GET['seller']??EBAY_USER;

if(ebayApi::oauth2_refreshtoken_exists($seller)){
    if(!ebayApi::oauth2_usertoken_exists($seller) or ebayApi::get_oauth2_usertoken_lifetime($seller) < 1){
        try{
            ebayApi::refresh_oauth2_usertoken($seller);
        }catch(Exception $e){
            $api_error = 'refresh_oauth2_usertoken() for seller '.$seller.'  '.$e->getMessage();
        }
    }
}
function ebay_api_feed_get_api_domain( $env ){
    if($env == 'sandbox'){
        return "https://api.sandbox.ebay.com/";
    }
    return "https://api.ebay.com/";
}

function ebay_api_feed_call(string $link,string $token, string $payload='', $post = true, $file = ''){
    global $save_path;
        /*printf('link: %s<br />token: %s<br />payload: %s, post: %s, file: %s',
                $link,substr($token,0,25),$payload, ($post === true) ? 'yes' : 'no', $file
        );*/
        $ch = curl_init($link);
        $add_header = array(
            'Authorization:Bearer ' . $token,
            'X-EBAY-C-MARKETPLACE-ID: EBAY_DE'
        );
        $post_fields = [];
        if(strpos($link,'upload_file')>0){
            $add_header[] = 'Content-Type:multipart/form-data';
            $post_fields = array('file'=> new CURLFILE(
                    $file
                ),
                'type'=>'form-data','name'=>'file');
        }else{
            if(strpos($link,'download_result_file')<=0 and strpos($link,'download_input_file')<=0){
                $add_header[] = 'Accept:application/json';
                $add_header[] = 'Content-Type:application/json';
            }
        }
        
        //curl_setopt($ch, CURLINFO_HEADER_OUT, true); // enable tracking
        
	curl_setopt($ch, CURLOPT_HTTPHEADER, $add_header);
        //curl_setopt($ch, CURLHEADER_SEPARATE, true);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        if($post === true){
            curl_setopt($ch, CURLOPT_POST, 1);
            if(sizeOf($post_fields)){
                curl_setopt($ch, CURLOPT_POSTFIELDS, $post_fields);
            }
        }
        curl_setopt($ch, CURLOPT_HEADER, 1);
        //scurl_setopt($ch, CURLOPT_PROXY, '127.0.0.1:8888');
        if($payload != ''){
            curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
        }
        $response = curl_exec($ch);
        //$headerSent = curl_getinfo($ch, CURLINFO_HEADER_OUT ); // request headers
        $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
        $headers = substr($response, 0, $header_size);
        $body = substr($response, $header_size);
        $info = curl_getinfo($ch);  
        curl_close($ch);

        $headers = explode("\r\n", $headers); // The seperator used in the Response Header is CRLF (Aka. \r\n) 
        return ['body'=>$body, 'headers'=>$headers];
}
$basics = new basics;
$save_path = main::get_secure_path().DIRECTORY_SEPARATOR.'LMS/';
if(!is_dir($save_path)){
    mkdir($save_path);
}
if(defined('SPECIALS_REVISE_USER_SITE_XML_FILENAME')){
    $specials_path = dirname(SPECIALS_REVISE_USER_SITE_XML_FILENAME);
    if(!is_dir($specials_path)){
        mkdir($specials_path);
    }
}
$ebay_user = xtc_get_ebay_users();

$config[$env]['oauthUserToken'] = ebayApi::get_oauth2_usertoken($seller);

switch($action){
    case 'get_active_inventory':
        if(isset($_GET['ai_action'])){
            switch($_GET['ai_action']){
                case 'ai_download':
                    // with a sandbox dummy handling
                    $taskID = (isset($_GET['taskId']))?$_GET['taskId']:'task-20-2990393196545';
                    $link = ebay_api_feed_get_api_domain( $env )."sell/feed/v1/task/".$taskID.'/download_result_file';
                    $response = ebay_api_feed_call($link,$config[$env]['oauthUserToken'],'',false);
                    $fn = '';
                    foreach($response['headers'] as $h){
                        if(strpos($h,'content-disposition:')>-1){
                            $parts = explode(';',$h);
                            foreach($parts as $part){
                                if(strpos($part, 'filename')>-1){
                                    $fn .= trim(str_replace('filename =','',$part));
                                }
                            }
                        }
                    }
                    if(!empty($fn)){
                        $file = \main::get_exportdata_path().$seller.'-'.$fn;
                        if(file_exists($fn)){
                            unlink($fn);
                        }
                        try {
                            $fp = fopen($file, 'wb');
                            fwrite($fp, $response['body']);
                            fclose($fp);
                            $basics = new basics;
                            $basics->download_file($file,true);
                        } catch (Exception $e) {
                            throw new Exception('cant write to '.$file.'. Error: '.$e->getMessage());
                        }
                    }
                    die('Done');
                    break;
                case 'ai_status':
                    // with a sandbox dummy handling
                    $taskID = (isset($_GET['taskId']))?$_GET['taskId']:'task-20-2990393196545';
                    
                    $link = ebay_api_feed_get_api_domain( $env )."sell/feed/v1/inventory_task/".$taskID;
                    $response = ebay_api_feed_call($link,$config[$env]['oauthUserToken'],'',false);
                    yes_debug($response);
                    exit;
                    break;
                case 'create_ai':
                    $link = ebay_api_feed_get_api_domain( $env )."sell/feed/v1/inventory_task";
                    // GET
                    $response = ebay_api_feed_call($link,$config[$env]['oauthUserToken'],json_encode(
                        [
                            'feedType'=>'LMS_ACTIVE_INVENTORY_REPORT',
//                            'filterCriteria'=>["listingFormat"=>'FIXED_PRICE'],
                            'schemaVersion'=>'1.0'
                        ]
                    ),true);
                    $taskId = '';
                    foreach($response['headers'] as $h){
                        if(stripos($h,'location: https')>-1){
                            $parts = explode('sell/feed/v1/task/',$h);
                            $taskId = $parts[1];
                        }
                    }
                    die(json_encode([
                        'MSG'=>'Neuer Active Inventory Report wurde von eBay angefordert.',
                        'taskId'=>$taskId,
                        'taskDate'=>date('Y-m-d H:i:s')
                    ]));
            }
        }
        $report = 'LMS_ACTIVE_INVENTORY_REPORT';
        $link = ebay_api_feed_get_api_domain( $env )."sell/feed/v1/inventory_task?feed_type=".$report."&seller=".$seller."&look_back_days=1&limit=5";
        $response = ebay_api_feed_call($link,$config[$env]['oauthUserToken'],'',false);
        $json = json_decode($response['body']);
        $errors = [];
        $smarty = new yesSmarty();
        if(isset($json->errors)){
            foreach($json->errors as $Error){
                $errors[] = sprintf("<p>%s Error #%s - %s/%s: %s</p>", $Error->category,$Error->errorId,
                    $Error->domain, $Error->subdomain,
                    $Error->message
                );
            }
        }
        $limit = $json->limit;
        if(isset($json->tasks)){
            $show_from = ($json->offset>0)?$limit*$json->offset:1;
            $show_to = ($show_from-1)+sizeOf($json->tasks);
        }else{
            $show_from = 0;
            $show_to = 0;
        }
        if(isset($_GET['json']) and $_GET['json'] == 1){
            die(json_encode([
                'MSG'=>'',
                'TASKS'=>$json->tasks,
                'error_msg'=>implode('<br />',$errors),
                'title'=>sprintf('%s "%s" %d - %d von insgesamt %d',
                    $seller, $report, $show_from, $show_to, $json->total
                ),
            ]));
        }
        $maxsize = ini_get('upload_max_filesize');
        if(substr($maxsize,-1) == 'M'){
            $maxsize .= 'B';
        }
        $smarty->assign([
            'ebay_user'=>$ebay_user,
            'ebay_user_num'=>sizeOf($ebay_user),
            'form_switch_seller'=> sprintf('<form name="switch_seller" method="get" action="%s" onsubmit="return switch_seller()">',
                xtc_href_link(basename(__FILE__))
            ),
            'input_action'=>xtc_draw_hidden_field('action','get_active_inventory'),
            'input_seller'=>xtc_draw_pull_down_menu('seller', $ebay_user, $seller),
            'error_msg'=>implode('<br />',$errors),
            'title'=>sprintf('%s "%s" %d - %d von insgesamt %d',
                $seller, $report, $show_from, $show_to, $json->total
            ),
            'seller'=>$seller,
            'TASKS'=>$json->tasks,
            'upload_form'=>sprintf('<form name="v2_sync_form" action="%s" method="post" enctype="multipart/form-data">',
                xtc_href_link('system.php','action=v2_sync')
            ),
            'upload_max_size'=>$maxsize

        ]);
        $smarty->display('system.ebay_sync_v2.html');
        exit;
        break;
    case 'dbg':
        $taskId = $_GET['taskId'];
        if(isset($_GET['dl_input'])){
            $link = ebay_api_feed_get_api_domain( $env )."sell/feed/v1/task/".$taskId.'/download_input_file';
            $response = ebay_api_feed_call($link,$config[$env]['oauthUserToken'], '',false);
            if(strpos($response['headers'][0],'200 OK') > 0){
                header("Pragma: public", true);
                header("Expires: 0"); // set expiration time
                header('Content-type: application/x-gzip');
                header('Content-Disposition: attachment; filename=ResultFile-'.$taskId.'.tar.gz');
                header("Content-Transfer-Encoding: binary");
                echo $response['body'];
                exit;
            }else{
                die('Error:<br /><pre>'.print_r($response['headers'],true).'</pre>');
            }
        }
        if(isset($_GET['dl_response'])){
            $link = ebay_api_feed_get_api_domain( $env )."sell/feed/v1/task/".$taskId.'/download_result_file';
            $response = ebay_api_feed_call($link,$config[$env]['oauthUserToken'], '',false);
            if(strpos($response['headers'][0],'200 OK') > 0){
                header("Pragma: public", true);
                header("Expires: 0"); // set expiration time
                header('Content-type: application/x-gzip');
                header('Content-Disposition: attachment; filename=ResultFile-'.$taskId.'.tar.gz');
                header("Content-Transfer-Encoding: binary");
                echo $response['body'];
                exit;
            }else{
                die('Error:<br /><pre>'.print_r($response['headers'],true).'</pre>');
            }
        }
        
        $link = ebay_api_feed_get_api_domain( $env )."sell/feed/v1/task/".$taskId;
        $payload = '';
        $response = ebay_api_feed_call($link,$config[$env]['oauthUserToken'], $payload,false); // get
        $task = json_decode($response['body']);
        printf('<h1>Task %s</h1><h2>%s / Status %s</h2><h3>created: %s / completed: %s</h3><p>SuccessCount: %d / failureCount: %d</p>',
                $task->taskId,$task->feedType,$task->status,
                $task->creationDate, $task->completionDate,
                $task->uploadSummary->successCount,
                $task->uploadSummary->failureCount
        );
        if($task->status == 'COMPLETED'){
            echo '<a href="?action=dbg&dl_response=1&taskid='.$taskId.'">DL Response</a>&nbsp;';
        }
        echo '<a href="?action=dbg&dl_input=1&taskId='.$taskId.'">DL Input File</a>&nbsp;';
        
        exit;
        break;
    case 'ebay_specials_revise':
        // ---
        // Diese Auktionen werden bei deaktivierung des special Eintrags
        // auf den Original Preis gerevised
        // WENN DER ARTIKEL AUF DEN SONDERPREIS GEREVISED WURDE, ERHAELT DER
        // specials_ebay_revise EINTRAG DAS FLAG is_revise=1
        // UM EINEN ARTIKEL WIEDER AUF DEN ORIGINALPREIS ZU REVISEN, MUSS DAS
        // FLAG status AUF 1 SEIN UND is_revised DEN WERT 1 HABEN
        // ---
      
	$normal_auctions = array();
	$variation_auctions = array();
        // status, is_revised
        $no_auctions = 0;
        $auctions = specials_ebay_revise::get_items_by_status(1, 1);
        if(!sizeOf($auctions)){
            $no_auctions++;
        }
        foreach($auctions as $serID){
            $ser = new specials_ebay_revise($serID);
            $ser->get_revise_auction_data_array($normal_auctions, $variation_auctions);
	}
        // status, is_revised
        $auctions = specials_ebay_revise::get_items_by_status(0,0);
        if(!sizeOf($auctions)){
            $no_auctions++;;
        }
        foreach($auctions as $serID){
            $ser = new specials_ebay_revise($serID);
            $ser->get_revise_auction_data_array($normal_auctions, $variation_auctions, true);
	}
        if($no_auctions == 2){
            die(MSG_ERROR_NO_EBAY_REVISE_AUCTIONS);
        }
	$base_xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
		<BulkDataExchangeRequests>
		  <Header>
		    <SiteID>%s</SiteID>
		    <Version>739</Version>
		  </Header>
		</BulkDataExchangeRequests>";
	$dom = array();
        foreach($variation_auctions as $user => $sites){
		if(!isset($dom[$user])){
			$dom[$user] = array();
		}
		foreach($sites as $siteID => $diff_auctions){
			if(!isset($dom[$user][$siteID])){
				$dom[$user][$siteID] = array();
			}
			foreach($diff_auctions as $ebay_id=>$products){
				if(!isset($dom[$user][$siteID]['ReviseFixedPriceItem'])){
					$xml = sprintf($base_xml,$siteID);
					$dom[$user][$siteID]['ReviseFixedPriceItem'] = new SimpleXMLElement($xml);
				}
				$RIS = $dom[$user][$siteID]['ReviseFixedPriceItem']->addChild('ReviseFixedPriceItemRequest');
				$RIS->addAttribute('xmlns', 'urn:ebay:apis:eBLBaseComponents');
				$RIS->addChild('Version',739);
				$IS = $RIS->addChild('Item');
				$IS->addChild('ItemID',$ebay_id);
				$VARIATIONS = $IS->addChild('Variations');
				foreach($products as $pID=>$auction){
					$V = $VARIATIONS->addChild('Variation');
					$V->addChild('SKU',$auction['sku']);
					$V->addChild('StartPrice',number_format($auction['price'],2,'.',''));
				}
			}
		}
        }
        foreach($normal_auctions as $user=>$sites){
		if(!isset($dom[$user])){
			$dom[$user] = array();
		}
		foreach($sites as $siteID => $products){
			if(!isset($dom[$user][$siteID])){
				$dom[$user][$siteID] = array();
			}
			foreach($products as $pID => $auction){
				$type = ($auction['type'] == 'Chinese') ? 'ReviseItem' : 'ReviseFixedPriceItem';
				$type_req = ($auction['type'] == 'Chinese') ? 'ReviseItemRequest' : 'ReviseFixedPriceItemRequest'; 
				if(!isset($dom[$user][$siteID][$type])){
					$xml = sprintf($base_xml,$siteID);
					$dom[$user][$siteID][$type] = new SimpleXMLElement($xml);
				}
				$RIS = $dom[$user][$siteID][$type]->addChild($type_req);
				$RIS->addAttribute('xmlns', 'urn:ebay:apis:eBLBaseComponents');
				$RIS->addChild('Version',739);
				$IS = $RIS->addChild('Item');
				$IS->addChild('ItemID',$auction['ebay_id']);
				$IS->addChild('StartPrice',number_format($auction['price'],2,'.',''));
			}
		}
        }
	$create_upload_files = array();
	foreach($dom as $user=>$sites){
            foreach($sites as $siteID=>$reqTypes){
                foreach($reqTypes as $reqType=>$lms_xml){

                    $xml_filename = sprintf(SPECIALS_REVISE_USER_SITE_XML_FILENAME,
                            $user, $siteID, $reqType
                    );
                    $gz_filename = $xml_filename.'.gz';
                    if(is_file($gz_filename)){
                            unlink($gz_filename); // wird neu erzeugt, also ggf loeschen
                    }
                    $fp = gzopen ($gz_filename, 'w9');
                    gzwrite ($fp, $lms_xml->asXML()); 
                    gzclose ($fp);
                    $create_upload_files[] = $gz_filename;
                }
            }
	}
        
        $task_ids = [];
        
        foreach($create_upload_files as $cuf){
            // FUER ERZEUGTE DATEIEN UPLOAD JOB IDS ERZEUGEN
            $link = ebay_api_feed_get_api_domain( $env )."sell/feed/v1/task";
            $parts = explode('LMS_SPECIALS_PRICE_REVISE_RESET_USER_',basename($cuf));
            $type_str = current(array_reverse(explode('_TYPE_',$parts[1])));
            $type = str_replace('.xml.gz','',$type_str);
            //testuser_mario2020_SITE_77_TYPE_ReviseFixedPriceItem')
            $feedType = ($type == 'ReviseFixedPriceItem') ? 'LMS_REVISE_FIXED_PRICE_ITEM' : 'LMS_REVISE_ITEM';
            $schema = "739";
            $payload = json_encode(array(
                "schemaVersion"=>$schema,
                "feedType"=>$feedType
            ));
            $response = ebay_api_feed_call($link,$config[$env]['oauthUserToken'], $payload);
            if(strpos($response['headers'][0],'200 OK') <= 0 and strpos($response['headers'][0],'202 Accepted') <= 0 ){
                yes_mail_debug('356:'.print_r($response,true));
                $json = json_decode($response['body']);
                $errors = [];
                foreach($json->errors as $err){
                    $errors[] = sprintf("[%s/%s Error #%s] %s",
                        $err->domain,
                        $err->subdomain,
                        $err->errorId,
                        $err->message
                    );
                }
                if($_SESSION['customer_id'] == 1){
                    yes_debug($response);
                }
                die(MSG_CREATE_UPLOAD_JOB_ERROR.'<br />'.implode('<br />',$errors));
            }
            foreach($response['headers'] as $row){

                $parts = explode(':',trim($row));
                if($parts[0]=='location'){
                    $task_ids[] = current(array_reverse(explode('/',$parts[2])));
                }
            }
        }
        // UPLOAD ZU DEN TASKIDs STARTEN
        if(!sizeOf($create_upload_files)){
        	die('Keine Dateien erzeugt');
        }
        foreach($create_upload_files as $nr => $file){
            
            $link = ebay_api_feed_get_api_domain( $env )."sell/feed/v1/task/".$task_ids[$nr].'/upload_file';
            $payload = '';
            $response = ebay_api_feed_call($link,$config[$env]['oauthUserToken'], $payload, true, $file);
            if(strpos($response['headers'][0],'200 OK') <= 0 && strpos($response['headers'][0],'100 Continue') <= 0){
                yes_mail_debug('387:'.print_r($response,true));
                $json = json_decode($response['body']);
                $errors = [];
                foreach($json->errors as $err){
                    $errors[] = sprintf("[%s/%s Error #%s] %s",
                        $err->domain,
                        $err->subdomain,
                        $err->errorId,
                        $err->message
                    );
                }
                if($_SESSION['customer_id'] == 1){
                    yes_debug($response);
                }
                die(MSG_CREATE_UPLOAD_JOB_ERROR.'<br />'.implode('<br />',$errors));
            }
            copy($file, $file.'-'.$task_ids[$nr]);
            unlink($file);
        }
        printf(
                MSG_SUCCESS_SPECIALS_REVISE_FILES_CREATED,
                sizeOf($create_upload_files)
        );
        echo yes_draw_href_button('Reload',basename(__FILE__));
        exit;
        break;
    case 'lms_price_revise':
        $expired = ebay_multi_edit_price_revise::get_expired();
        if(is_file(MULTI_EDIT_GZ_DATAFILE)){
            die('Invalid Call, Datafile exists');
        }
        if(!sizeOf($expired)){
            die('Invalid Call, no items to revise');
        }
        $base_xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
                <BulkDataExchangeRequests>
                  <Header>
                    <SiteID>%s</SiteID>
                    <Version>739</Version>
                  </Header>
                </BulkDataExchangeRequests>";
        $dom = array();
        foreach($expired as $emeprID){
            $emepr = new ebay_multi_edit_price_revise($emeprID);
            $ea = new ebay_auction($emepr->getEbay_auctions_id());
            if(!isset($dom[$ea->getUser()])){
                $dom[$ea->getUser()] = array();
            }
            $site = $EBAYAPI->get_site_id_from_name($ea->getSite());
            if(!isset($dom[$ea->getUser()][$site])){
                $dom[$ea->getUser()][$site] = array();
            }
            if(!isset($dom[$ea->getUser()][$site][$ea->getType()])){

                // DAS IST DOCH FALSCH? EINTRAEGE HABEN WIR DOCH BEREITS?
                // $eme = new ebay_multi_edit();
                // $eme->setUser($ea->getUser());
                // $eme->setRequest_type($ea->getType());
                // $eme->setSite_id($site);
                // $emeID = $eme->save();
                $xml = sprintf($base_xml,$site);
                $dom[$ea->getUser()][$site][$ea->getType()] = new SimpleXMLElement($xml);
            }
            switch($ea->getType()){
                case 'Chinese':
                    $request_name = 'ReviseItemRequest';
                    break;
                default:
                    $request_name = 'ReviseFixedPriceItemRequest';
                    break;
            }
            $RFPI = $dom[$ea->getUser()][$site][$ea->getType()]->addChild($request_name);
            $RFPI->addAttribute('xmlns', 'urn:ebay:apis:eBLBaseComponents');
            $RFPI->addChild('Version',739);
            $I = $RFPI->addChild('Item');
            $I->addChild('ItemID',$ea->getEbayId());
            $I->addChild('StartPrice',number_format($emepr->getPrice(),2,'.',''));
        }
        $LMS = new LMS;
        $current_jobs = array();
        $unlink = array();
        $has_err = false;
        $zip = new ZipArchive;
        if($zip->open(MULTI_EDIT_GZ_DATAFILE, ZipArchive::CREATE) === TRUE){
            foreach($dom as $user=>$sites){
                foreach($sites as $siteID=>$auction_types){
                    foreach($auction_types as $auction_type => $lms_xml){
                        $xml_filename = sprintf(MULTI_EDIT_USER_SITE_XML_FILENAME,
                                $user, $siteID, $auction_type
                        );
                        $gz_filename = $xml_filename.'.gz';
                        if(is_file($gz_filename)){
                                unlink($gz_filename); // wird neu erzeugt, also ggf loeschen
                        }
                        $fp = gzopen ($gz_filename, 'w9');
                        gzwrite ($fp, $lms_xml->asXML()); 
                        gzclose ($fp);
                        $zip->addFile($gz_filename, basename($gz_filename));
                        $unlink[] = $gz_filename;
                    }
                }
            }
            // All files are added, so close the zip file.
            $zip->close();
            foreach($unlink as $file){
                unlink($file);
            }
        }
        foreach($expired as $emeprID){
            $emepr = new ebay_multi_edit_price_revise($emeprID);
            //$emepr->delete();
            // NICHT LOESCHEN
            // AUKTION WURDE AUF ALTEN PREIS GESETZT, DER RESPONSE VON EBAY
            // MUSS ABGEWARTET WERDEN
            $emepr->setRevise_status(1);
            $emepr->update_revise_status();
        }
        $messageStack->add_session(sprintf(MSG_SUCCESS_LMS_REVISE_FILE_CREATED),'success');
        $_SESSION['price_revise_created'] = 1;
        xtc_redirect(xtc_href_link(basename(__FILE__)));
        break;
    case 'price_revise':
        $revise = [];
        require_once(DIR_FS_INC.'xtc_get_ebay_link.inc.php');
        $expired = ebay_multi_edit_price_revise::get_expired();
        foreach($expired as $emeprID){
            $revise[] = new ebay_multi_edit_price_revise( $emeprID );
        }
        printf('<div class="main"><p>%s</p>',PRICE_REVISE_INTRO);
        printf('<table class="yesListTable_minimal lms_price_revise_table"><thead><tr><th>eBay ID</th><th>%s</th><th>%s</th><th>%s</th></tr></thead><tbody>',
                CURRENT_AUCTION_PRICE,
                REVISE_AUCTION_PRICE,
                REVISE_DATE
        );
        foreach($revise as $r){
            $ea = new ebay_auction($r->getEbay_auctions_id());
            printf('<tr><td><a href="%s" target="_blank">%s</a></td><td align="right">%s</td><td align="right">%s</td><td>%s</td></tr>',
                    xtc_get_ebay_link($ea->getSite()).$ea->getEbayId(),$ea->getEbayId(),
                    number_format($ea->getAuctionprice(),2,',',''),
                    number_format($r->getPrice(),2,',',''),
                    xtc_date_short($r->getRevise_date())
            );
        }
        echo '</tbody></table>';
        printf('<button style="padding: 4px; margin-top: 4px;" class="ui-button ui-corner-all ui-state-highlight" onclick="window.location.href=\'?action=lms_price_revise\'">%s</button>',
                BUTTON_START_REVISE
        );
        echo '</div>';
        exit;
        break;
    case 'process_specials_upload_file':
        $files = basics::get_directory_content($specials_path.DIRECTORY_SEPARATOR);
        $file_counter = 0;
        foreach($files as $file){
            $file_counter++;
            printf('<input disabled="disabled" readonly="readonly" type="checkbox" name="gzfile[]" value="%s" /> Export File #%d<br />',
                    $file, $file_counter
            );
        }
        echo '<br /><br /><button style="padding: 3px;" class="process_upload_files_button ui-button ui-corner-all ui-state-highlight" onclick="process_upload_files()">Start</button>';
        exit;
        break;
    case 'process_upload_file':
        $zip = $save_path.'MULTI_EDIT'.DIRECTORY_SEPARATOR.'LMS_MULTI_EDIT_DATAFILES.zip';
        unzip($zip);
        $files = $basics->get_directory_content($save_path.'MULTI_EDIT/');
        $file_counter = 0;
        foreach($files as $file){
            if($file != 'LMS_MULTI_EDIT_DATAFILES.zip'){
                $file_counter++;
                printf('<input disabled="disabled" readonly="readonly" type="checkbox" name="gzfile[]" value="%s" /> Export File #%d<br />',
                        $file, $file_counter
                );
            }
        }
        echo '<br /><br /><button style="padding: 3px;" class="process_upload_files_button ui-button ui-corner-all ui-state-highlight" onclick="process_upload_files()">Start</button>';
        exit;
        break;
    case 'delete_report_file':
        $file = basename($_GET['file']);
        if(is_file($save_path.$file)){
            unlink($save_path.$file);
            $messageStack->add_session(sprintf(
                    MSG_SUCCESS_REPORT_FILE_DELETED,$file
            ));
        }
        xtc_redirect(xtc_href_link(basename(__FILE__)));
        break;
    case 'download_report_file':
        $file = basename($_GET['file']);
        if(is_file($save_path.$file)){
            $basics->download_file($save_path.$file);
        }
        xtc_redirect(xtc_href_link(basename(__FILE__)));
        break;
    case 'download':
        $taskId = ($command_line) ? 'MUSSNOCHGEBAUTWERDEN':$_GET['taskId'];
        $link = ebay_api_feed_get_api_domain( $env )."sell/feed/v1/task/".$taskId."/download_result_file";
        // GET
        $response = ebay_api_feed_call($link,$config[$env]['oauthUserToken'],'',false);
        $parts = explode(';',$response['headers'][2]);
        $file_name_response = explode('=',$parts[1]);
        $file_name = trim($file_name_response[1]);
        $basics->create_file($save_path.$file_name, $response['body'], 'wb');
        if($command_line){
            die('done');
        }
        $messageStack->add_session(sprintf(
                MSG_SUCCESS_REPORT_DOWNLOADED, $file_name
        ),'success');
        xtc_redirect(xtc_href_link(basename(__FILE__)));
        break;
    case 'task':
        $link = ebay_api_feed_get_api_domain( $env )."sell/feed/v1/task/task-16-124670";
        // GET
        $response = ebay_api_feed_call($link,$config[$env]['oauthUserToken'],'',false);
        $json = json_decode($response['body']);
        switch($json->status){
            case 'COMPLETED':
                switch($json->type){
                    case 'LMS_ACTIVE_INVENTORY_REPORT':
                        $task_id = $json->task_id;
                        break;
                }
                break;
        }
        exit;
        break;
    case 'inventory_task':
        // POST
        $link = ebay_api_feed_get_api_domain( $env )."sell/feed/v1/inventory_task";
        //$appConfig = parse_ini_file("config.ini");
        
        //payload
        $feedType = "LMS_ACTIVE_INVENTORY_REPORT";
        $payload = json_encode(array(
            "schemaVersion"=>"1.0",
            "feedType"=>$feedType
        ));

        $response = ebay_api_feed_call($link,$config[$env]['oauthUserToken'], $payload);

        foreach($response['headers'] as $row){
            $parts = explode(':',trim($row));
            if($parts[0]=='location'){
                $task_link = trim($parts[1]);
            }
        }
        if($command_line){
            die(sprintf(
                    "Seller %s / FeedType %s created. Link: %s",
                    $seller, $feedType,$task_link
            ));
        }else{
            $messageStack->add_session(sprintf(
                    MSG_SUCCESS_INVENTORY_TASK, $seller
            ),'success');
            xtc_redirect(xtc_href_link(basename(__FILE__)));
        }
        exit;
        break;
    case 'create_upload_job':
        // WIRD AUS DER JS FUNCTION process_upload_files() HERAUS AUFGERUFEN
        // POST
        $link = ebay_api_feed_get_api_domain( $env )."sell/feed/v1/task";
        $feedType = "LMS_REVISE_FIXED_PRICE_ITEM";
        $schema = "739";
        $payload = json_encode(array(
            "schemaVersion"=>$schema,
            "feedType"=>$feedType
        ));

        $response = ebay_api_feed_call($link,$config[$env]['oauthUserToken'], $payload);
        if(strpos($response['headers'][0],'200 OK') <= 0 and strpos($response['headers'][0],'202 Accepted') <= 0 ){
            yes_mail_debug('661:'.print_r($response,true));
            $json = json_decode($response['body']);
            $errors = [];
            foreach($json->errors as $err){
                $errors[] = sprintf("[%s/%s Error #%s] %s",
                    $err->domain,
                    $err->subdomain,
                    $err->errorId,
                    $err->message
                );
            }
            die(json_encode([
                'MSG'=>MSG_CREATE_UPLOAD_JOB_ERROR.'<br />'.implode('<br />',$errors)
            ]));
        }
        foreach($response['headers'] as $row){
            
            $parts = explode(':',trim($row));
            if($parts[0]=='location'){
                $task_id = current(array_reverse(explode('/',$parts[2])));
                die(json_encode([
                    'MSG'=>'',
                    'taskId'=>$task_id
                ]));
            }
        }
        die(json_encode([
            'MSG'=>'Invalid Response'
        ]));
        break;
    case 'upload':
        // POST
        // WIRD AUS DER JS FUNCTION process_upload_files() HERAUS AUFGERUFEN
        // ES WERDEN PER GET file UND taskId UEBERGEBEN
        
        $link = ebay_api_feed_get_api_domain( $env )."sell/feed/v1/task/".$_GET['taskId'].'/upload_file';
        if(strpos($_GET['file'],'LMS_SPECIALS_PRICE_REVISE_') > -1){
	        $file = $save_path.'SPECIALS_REVISE'.DIRECTORY_SEPARATOR.$_GET['file'];
        }else{
	        $file = $save_path.'MULTI_EDIT'.DIRECTORY_SEPARATOR.$_GET['file'];
        }
        $zipped = file_get_contents($file);
        $xml = simplexml_load_string(gzdecode($zipped));
        
        $node = (isset($xml->ReviseFixedPriceItemRequest)) ? 'ReviseFixedPriceItemRequest':'ReviseItemRequest';
        foreach($xml->$node as $item){
            $ebay_id = $item->Item->ItemID;
            $update_sql_array = [
                'task_id'=>$_GET['taskId']
            ];
            $eaID = $EBAYAPI->get_ebay_auctions_id_from_ebay_id($ebay_id);
            
            // ES KOENNEN NOCH AUS PREIS REVISE DATENSAETZE DA SEIN, DIESE HABEN
            // DANN EINEN ebay_multi_edit_price_revise EINTRAG
            $query = xtc_db_query(sprintf(
                    "SELECT emei.ebay_multi_edit_items_id FROM ebay_multi_edit_items emei LEFT JOIN ebay_multi_edit_price_revise emepr USING(ebay_multi_edit_items_id) WHERE emei.ebay_auctions_id='%d' AND emepr.ebay_multi_edit_price_revise_id IS NULL",
                    $eaID
            ));
            $record = xtc_db_fetch_array($query);
            xtc_db_perform('ebay_multi_edit_items',$update_sql_array,'update',"ebay_multi_edit_items_id='".$record['ebay_multi_edit_items_id']."'");
        }
        $payload = '';
        $response = ebay_api_feed_call($link,$config[$env]['oauthUserToken'], $payload, true, $file);
        if(strpos($response['headers'][0],'200 OK') <= 0 and strpos($response['headers'][0],'202 Accepted') <= 0 and strpos($response['headers'][0],'100 Continue') <= 0 ){
            yes_mail_debug('721: '.print_r($response,true));
            $errors = [];
            foreach($json->errors as $err){
                $errors[] = sprintf("[%s/%s Error #%s] %s",
                    $err->domain,
                    $err->subdomain,
                    $err->errorId,
                    $err->message
                );
            }
            die(json_encode([
                'MSG'=>MSG_CREATE_UPLOAD_JOB_ERROR.'<br />'.implode('<br />',$errors)
            ]));
        }
        unlink($file);
        if(is_file(MULTI_EDIT_GZ_DATAFILE)){
            unlink(MULTI_EDIT_GZ_DATAFILE); // Kann zu diesem Zeitpunkt weg
        }
        die(json_encode([
            'MSG'=>'' // SUCCESS
        ]));
        break;
    case 'get_result_file_special':
        $taskId = xtc_db_input($_GET['taskId']);
        $real_path = $save_path.'SPECIALS_REVISE'.DIRECTORY_SEPARATOR;
        $files = basics::get_directory_content( $real_path );
        $process_file = '';
        foreach($files as $f){
            if(strpos($f,'.gz-'.$taskId)>0){
                $process_file = $f;
            }
        }
        if($process_file == ''){
            die(sprintf(
                MSG_ERROR_SPECIALS_REVISE_MISSING_RESULT_FILE,
                $taskId
            ));
        }
        $result_save_path = $save_path.$basics->get_valid_filename_from_string($_GET['taskId']).DIRECTORY_SEPARATOR;
        if(is_dir(substr($result_save_path,0,-1).'-DONE')){
            die('<b>Error</b> '.ERROR_TASK_ALWAYS_PROCESSED);
        }
        if(!is_dir($result_save_path)){
            mkdir($result_save_path);
        }
        $link = ebay_api_feed_get_api_domain( $env )."sell/feed/v1/task/".$taskId.'/download_result_file';

        $response = ebay_api_feed_call($link,$config[$env]['oauthUserToken'], '',false);
        if(strpos($response['headers'][0],'200 OK') > 0){
            $file_parts = explode(';',$response['headers'][2]);
            $file_name_parts = explode(' = ',$file_parts[1]);
            $file_name = $file_name_parts[1];

            $basics->create_file($result_save_path.$file_name, $response['body'], 'w');
            $fn = unzip($result_save_path.$file_name);
            unlink($result_save_path.$file_name);
        }else{
            die('Error:<br /><pre>'.print_r($response['headers'],true).'</pre>');
        }
        $files = $basics->get_directory_content($result_save_path);
        
        
        $content = file_get_contents($result_save_path.$files[0]);
        // AUS DEM FILENAME MUESSEN WIR site_id UND user EXTRAHIEREN
        $str = $files[0];
        $matches = [];
        preg_match('/\_USER\_(.*)\_SITE\_/',$str, $matches);
        $user = $matches[1];
        $matches = [];
        preg_match('/\_SITE\_(.*)\_TYPE\_/',$str, $matches);
        $site_id = $matches[1];
        $matches = [];
        preg_match('/\_TYPE\_(.*)\.xml-/',$str, $matches);
        $request_name = $matches[1];
	$xml = simplexml_load_string($content);
	$errors = [];
        $notice_summary = [];
        $notice_msg = [];
        $dbg_messages = [];
        $summary = [];
        $xml_node = $request_name.'Response';
	foreach($xml->$xml_node as $ReviseFixedPriceItemResponse){
            if(!isset($ReviseFixedPriceItemResponse->ItemID) or empty($ReviseFixedPriceItemResponse->ItemID)){
                $errors[] = "Kein Auktionsdatensatz";
		continue;
            }
            $eaID = $EBAYAPI->get_ebay_auctions_id_from_ebay_id($ReviseFixedPriceItemResponse->ItemID);
            if($eaID<1){
                $errors[] = sprintf(
                    "Zur Auktion %s wurden von eBay Daten zur&uuml;ckgegeben, aber diese Auktion ist in YES nicht erfasst.",
                    $ReviseFixedPriceItemResponse->ItemID
                );
                continue;
            }
            $ebay_auction = new ebay_auction( $eaID );
            if(is_array($ebay_auction->variations) and sizeOf($ebay_auction->variations)){
                    // VARIANTEN ABGLEICH
                    foreach($ebay_auction->variations as $variation){
                            $serID = specials_ebay_revise::get_specials_ebay_revise_id_from_auction($eaID, $variation->sku);
                            $ser = new specials_ebay_revise($serID);
                            if($variation->sku != "".$ser->getSku()){
                                    continue;
                            }
                            $successful = true;
                            $new_price = ($ser->getStatus() == 0) ? $ser->getSpecial_price() : $ser->getOriginal_price();
                            $P = new product($variation->products_id,2);
                            $P->add_history(sprintf(
                                    EBAY_REVISE_HISTORY_VARIATION_SYNCED,
                                    $ebay_auction->ebay_id,
                                    $variation->sku,
                                    $new_price
                            ));
                            $summary[] = sprintf(
                                    EBAY_REVISE_HISTORY_VARIATION_SYNCED,
                                    $ebay_auction->ebay_id,
                                    $variation->sku,
                                    $new_price
                            );
                            $ser->update_auction_price();
                            // WENN AUF DEN SONDERPREIS GEREVISED WIRD, DANN SETZEN WIR
                            // is_revised AUF 1
                            if($ser->getStatus() == 0){
                                $ser->update_is_revised('1');
                            }else{
                                // WENN WIEDER DER ORIGINALPREIS GEREVISED WURDE, WIRD DER
                                // EINTRAG ENTFERNT, FERTIG
                                if(!specials_ebay_revise::delete_entry($ebay_auction->ebay_id, $variation->sku)){
                                        $dbg_messages[] = sprintf("User %s, Site %s, Auktion %s, SKU %s, pID %s: Konnte eBay Revise Auktionszuweisung nicht entfernen",
                                                $user, $site, $ebay_auction->ebay_id, $variation->sku, $variation->products_id
                                        );
                                }
                            }
                    }
            }else{
                    $successful = true;

                    $serID = specials_ebay_revise::get_specials_ebay_revise_id_from_auction($eaID, '');
                    $ser = new specials_ebay_revise($serID);
                    $new_price = ($ser->getStatus() == 0) ? $ser->getSpecial_price() : $ser->getOriginal_price();

                    $P = new product($ebay_auction->products_id,2);

                    $P->add_history(sprintf(
                            EBAY_REVISE_HISTORY_SYNCED,
                            $ebay_auction->ebay_id,
                            $new_price
                    ));
                    $summary[] = sprintf(
                            EBAY_REVISE_HISTORY_SYNCED,
                            $ebay_auction->ebay_id,
                            $new_price
                    );
                    // WENN AUF DEN SONDERPREIS GEREVISED WIRD, DANN SETZEN WIR
                    // is_revised AUF 1
                    $ser->update_auction_price();
                    if($ser->getStatus() == 0){
                            $ser->update_is_revised('1');
                    }else{
                        if(!specials_ebay_revise::delete_entry($ebay_auction->ebay_id, '')){
                                $dbg_messages[] = sprintf("User %s, Site %s, Auktion %s, pID %s: Konnte eBay Revise Auktionszuweisung nicht entfernen",
                                        $user, $site, $ebay_auction->ebay_id, $pID
                                );
                        }
                    }
            }
        }
        foreach($summary as $s){
            echo $s.'<br />';
        }
        if(sizeOf($dbg_messages) and $_SESSION['customer_id'] == 1){
            printf('<b>Debug:</b><p>%s</p>',implode('<br />',$dbg_messages));
        }
        if(sizeOf($errors)){
            printf('<b>Error:</b><p>%s</p>',implode('<br />',$errors));
        }
        unlink($real_path.$process_file); // DIE LOKALE DATENDATEI LOESCHEN
        unlink($result_save_path.$files[0]); // RESPONSE DATEI LOESCHEN
        // DAS substr BRAUCH ICH UM DEN LETZTEN / ABZUSCHNEIDEN
        rename($result_save_path,substr($result_save_path,0,-1).'-DONE');
        exit;
        break;
    case 'get_result_file':
        $result_save_path = $save_path.$basics->get_valid_filename_from_string($_GET['taskId']).DIRECTORY_SEPARATOR;
        if(is_dir(substr($result_save_path,0,-1).'-DONE')){
            die('<b>Error</b> '.ERROR_TASK_ALWAYS_PROCESSED);
        }
        if(!is_dir($result_save_path)){
            // GET
            $link = ebay_api_feed_get_api_domain( $env )."sell/feed/v1/task/".$_GET['taskId'].'/download_result_file';
            //$appConfig = parse_ini_file("config.ini");

            $response = ebay_api_feed_call($link,$config[$env]['oauthUserToken'], '',false);
            if(strpos($response['headers'][0],'200 OK') > 0){

                if(!is_dir($result_save_path)){
                    mkdir($result_save_path);
                }

                $file_parts = explode(';',$response['headers'][2]);
                $file_name_parts = explode(' = ',$file_parts[1]);
                $file_name = $file_name_parts[1];
                $basics->create_file($result_save_path.$file_name, $response['body'], 'w');
                $fn = unzip($result_save_path.$file_name);
                unlink($result_save_path.$file_name);
            }else{
                die('Error:<br /><pre>'.print_r($response['headers'],true).'</pre>');
            }
        }                
        
        $files = $basics->get_directory_content($result_save_path);
        $content = file_get_contents($result_save_path.$files[0]);
        // AUS DEM FILENAME MUESSEN WIR site_id UND user EXTRAHIEREN
        $str = $files[0];
        $matches = [];
        preg_match('/\_USER\_(.*)\_SITE\_/',$str, $matches);
        $user = $matches[1];
        $matches = [];
        preg_match('/\_SITE\_(.*)\_TYPE\_/',$str, $matches);
        $site_id = $matches[1];
        $matches = [];
        preg_match('/\_TYPE\_(.*)\.xml-/',$str, $matches);
        $request_name = $matches[1];
        
	$xml = simplexml_load_string($content);
	$errors = [];
        $notice_summary = [];
        $notice_msg = [];
        $xml_node = 'Revise'.$request_name.'Response';

	foreach($xml->$xml_node as $ReviseFixedPriceItemResponse){
            if(!isset($ReviseFixedPriceItemResponse->ItemID) or empty($ReviseFixedPriceItemResponse->ItemID)){
		        continue;
            }
            $eaID = $EBAYAPI->get_ebay_auctions_id_from_ebay_id($ReviseFixedPriceItemResponse->ItemID);
            if($eaID<1){
                $errors[] = sprintf(
                    "Zur Auktion %s wurden von eBay Daten zur&uuml;ckgegeben, aber diese Auktion ist in YES nicht erfasst.",
                    $ReviseFixedPriceItemResponse->ItemID
                );
                continue;
            }
            $ea = new ebay_auction( $eaID );
            $emeiID = ebay_multi_edit_items::get_ebay_multi_edit_item_id_from_task_id( $_GET['taskId'], $eaID );
            if($emeiID < 1){
                $errors[] = sprintf("Zur Auktion %s konnte kein Revise Datensatz ermittelt werden.",
                        $ReviseFixedPriceItemResponse->ItemID
                );
                continue;
            }
            
            if($ReviseFixedPriceItemResponse->Errors){
                $err = $ReviseFixedPriceItemResponse->Errors;
                $errors[] = sprintf('[%s Code %s] eBay auction %s: %s / %s',
                    $err->SeverityCode, $err->ErrorCode,
                    $ReviseFixedPriceItemResponse->ItemID,
                    $err->ShortMessage,$err->LongMessage
                );
            }
        
            $delete_emei = false;
            if(!sizeOf($errors)){
                $emei = new ebay_multi_edit_items( $emeiID );
                
                $original_auction_quantity = $ea->getQuantity();
                $original_auction_price = $ea->getAuctionprice();
                $products_id = $ea->getProductsId();
                
                $revise_old_price_done = false;
                // ebay_multi_edit_price_revise MIT revise_status=1
                $emeaprID = $emei->get_ebay_multi_edit_price_revise_id();
                if($emeaprID > 0){
                        $emepr = new ebay_multi_edit_price_revise($emeaprID);
                        //echo 'eaID #'.$eaID." wurde bereits gerevised und muss nun lokal aktualisiert werden\r\n";
                        $emepr->reset_local_auction_prices(); // lokaler auctioprice
                        $notice_summary[] = sprintf('Revise Auktion %s auf Ursprungspreis %s abgeschlossen.',
                                $ea->getEbayId(),
                                $emepr->getPrice()
                        );
                        $emepr->delete();
                        $delete_emei = true;
                        $revise_old_price_done = true;
                }
                
                if(!$revise_old_price_done){
                    if($emei->getRevise_date() != '0000-00-00 00:00:00' and $emei->getRevise_date() != NULL and $emei->getRevise_date() != 'NULL'){
                        //echo $current_emea->getEbay_auctions_id()." hat revise Preis\r\n";
                        // hier muss revise_status aus ebay_multi_edit_price_revise geprueft
                        // werden und wenn 1 dann lokale Auktion Preis aktualisieren und
                        // ebay_multi_edit_price_revise Eintrag geloescht werden.
                        if(!$emei->is_revised()){
                            //echo $current_emea->getEbay_auctions_id()." hat revise Preis - dieser wird nun gespeichert\r\n";		
                            $emei->add_ebay_multi_edit_price_revise($emei->getRevise_date(),$original_auction_price, $emei->getEbay_multi_edit_items_id());
                        }
                    }else{
                        // KEIN PREIS REVISE DATUM
                        $delete_emei = true;
                    }
                    $update_sql_array = array(
                        'duration'=>intval($emei->getDuration()),
                        'quantity'=>intval($emei->getQuantity()),
                        'auctionprice'=>(float)$emei->getPrice(),
                        'dispatchtimemax'=>intval($emei->getDispatchtimemax()),
                    );
                    if($update_sql_array['duration'] == NULL or strtolower($update_sql_array['duration']) == 'null' or empty($update_sql_array['duration'])){
                        unset($update_sql_array['duration']);
                    }
                    if($update_sql_array['dispatchtimemax'] == NULL or strtolower($update_sql_array['dispatchtimemax']) == 'null' or $update_sql_array['dispatchtimemax'] < 1){
                        unset($update_sql_array['dispatchtimemax']);
                    }
                    // EOF - BEI VARIANTEN KEIN PREIS/MENGE
                    $comm = array();
                    foreach($update_sql_array as $uk=>$uv){
                        if(EBAY_FEATURE_OUTOFSTOCK == 'True'){
                                if($uk == 'quantity' and $uv < 0){
                                    continue;
                                }
                        }else{
                                if($uk == 'quantity' and $uv == 0){
                                    continue;
                                }
                        }
                        if($uk == 'auctionprice' and $uv < 0.01){
                            unset($update_sql_array['auctionprice']);
                            continue;
                        }
                        if($uv !== NULL and $uv != 'NULL'){
                            $comm[] = $uk.': '.$uv;
                        }
                    }
                    if($products_id > 0 and (defined('EBAY_FEATURE_OUTOFSTOCK') and EBAY_FEATURE_OUTOFSTOCK == 'True' and $update_sql_array['quantity'] > -1) or ( (!defined('EBAY_FEATURE_OUTOFSTOCK') or EBAY_FEATURE_OUTOFSTOCK != 'True') and $update_sql_array['quantity']>0) ){
                        // IN_AUCTION quantity aktualisieren
                        $einstellmenge = $update_sql_array['quantity']-$original_auction_quantity;
                        ebay_auction::add_history($record['id'], $update_sql_array['quantity'], sprintf(
                            "[%s] Revise Auktion %s",
                            basename(__FILE__),$ea->getEbayId()
                        ));
                    }else{
                        unset($update_sql_array['quantity']);
                    }
                    
                    $notice_summary[] = 'Aktualisierungen Auktion '.$ea->getEbayId().'<br />'.implode(", ",$comm);
                    if(is_countable($update_sql_array) and sizeOf($update_sql_array)){
                        $update_sql_array['id'] = intval($eaID);
                        \YES4Trade\Model\ebay_auctions::update_ebay_auction($update_sql_array);
                        if($products_id > 0 and (defined('EBAY_FEATURE_OUTOFSTOCK') and EBAY_FEATURE_OUTOFSTOCK == 'True' and $update_sql_array['quantity'] > -1) or ( (!defined('EBAY_FEATURE_OUTOFSTOCK') or EBAY_FEATURE_OUTOFSTOCK != 'True') and $update_sql_array['quantity']>0) ){
                            // IN_AUCTION quantity aktualisieren
                            yes_update_products_in_auction_quantity($products_id,
                                yes_products_calc_in_auction_quantity($products_id),
                                sprintf('eBay Multi Edit #%s: Menge von %d auf %d aktualisiert.',
                                    $eaID, 
                                    $original_auction_quantity, 
                                    $update_sql_array['quantity']
                                ),
                                true // overwrite!
                            );
                        }else{
                            unset($update_sql_array['quantity']);
                        }
                    }else{
                        yes_mail_debug('Kein ebay_auctions UPDATE weil keine Werte aktualisiert werden mussten. '.print_r($emei,true));
                    }
                }
            } // END IF !errors
// todo            
            if($delete_emei){
                $emei->delete();
            }
        } // end foreach response items
        
        echo '<b>Zusammenfassung eBay Multi Edit</b><br /><br />';
        if(sizeOf($notice_summary)){
            echo implode('<br /><br />', $notice_summary);
        }
        if(sizeOf($notice_msg)){
            echo '<b>Fehler / Warnhinweise</b><br /><br />';
            echo implode('<br />',$notice_msg);
        }
        if(sizeOf($errors)){
            echo '<b>Fehler</b><br /><br />';
            echo implode('<br />',$errors);
        }
        echo '<p style="font-size: 0.8em;"><i>Sollten bei den Warnhinweisen/Fehlern Meldungen auftauchen die sich auf die zu aktualisierenden Daten bezogen hatten, vergleichen Sie bitte die Daten der gespeicherten laufenden YES Auktionen mit den eBay Auktiondaten und teilen uns mit falls Unstimmigkeiten vorliegen.</i></p>';
        unlink($result_save_path.$files[0]);
        rename(realpath($result_save_path), realpath($result_save_path).'-DONE');
        
        // DIE LOKAL ERZEUGTEN REVISE DATEN KOENNEN ZU DIESEM ZEITPUNKT SCHON
        // GELOESCHT WERDEN.
        $files = $basics->get_directory_content($save_path.'MULTI_EDIT'.DIRECTORY_SEPARATOR);
        // LMS/MULTI_EDIT/ Dateien loeschen
        foreach($files as $file){
            unlink($save_path.'MULTI_EDIT'.DIRECTORY_SEPARATOR.$file);
        }
        exit;
        break;
    case 'start_upload_job':
        $file = \main::get_exportdata_path().'LMS_MULTI_EDIT_DATAFILES.zip';
        break;
}
if(!$command_line){
    $smarty = new yesSmarty;
    $buttons = [];
    if(isset($_GET['page']) and $_GET['page'] == 'active_inventory'){
        $buttons[] = array(
            'text'=>BUTTON_CREATE_INVENTORY_FILE,
            'link'=>'javascript:lms_inventory_task_select()',
            'lbOn'=>false,
            'auth'=>true
        );
    }else{
        if(is_file($save_path.'MULTI_EDIT'.DIRECTORY_SEPARATOR.'LMS_MULTI_EDIT_DATAFILES.zip')){
            $smarty->assign([
                'BUTTON_UPLOAD'=>BUTTON_UPLOAD_REVISE_FILE,
                'UPLOAD_LINK'=>xtc_href_link(basename(__FILE__),'action=process_upload_file'),
            ]);
        }
        $expired = ebay_multi_edit_price_revise::get_expired();
        if(sizeOf($expired)){
            $smarty->assign([
                'BUTTON_PRICE_REVISE'=>sprintf(BUTTON_PRICE_REVISE ,sizeOf($expired)),
                'PRICE_REVISE_LINK'=>xtc_href_link(basename(__FILE__),'action=price_revise'),
            ]);
        }
    }
    
    $look_back_days = 3;
    // BOF - VERALTETE ORDNER LOESCHEN
    $directory_content = scandir($save_path);
    foreach($directory_content as $dc){
        switch($dc){
            case '.':
            case '..':
            case 'MULTI_EDIT':
                break;
            default:
                if(is_dir($save_path.$dc)){
                    $mtime = filemtime($save_path.$dc);
                    $abonded = time()-(60*60*24*$look_back_days);
                    if($mtime <= $abonded ){
                        rmdir($save_path.$dc);
                    }
                }
        }
    }
    // EOF - VERALTETE ORDNER LOESCHEN


    if(isset($_GET['page']) and $_GET['page'] == 'active_inventory'){
        $files = $basics->get_directory_content($save_path);
        $tasks = [];
        // GET
        $limit = 25;
        $offset = (isset($_GET['offset'])) ? (int)xtc_db_input($_GET['offset']) : 0;
        $feedType = "LMS_ACTIVE_INVENTORY_REPORT";
        $api_baselink = (EBAY_TESTMODE == '1') ? 'api.sandbox.ebay.com' : 'api.ebay.com';
        $link = sprintf(
                "https://%s/sell/feed/v1/inventory_task?feed_type=%s&limit=%d&offset=%d&look_back_days=%d",
                $api_baselink,$feedType,$limit,($offset*$limit),$look_back_days
        );
        $payload = '';
        $response = ebay_api_feed_call($link,$config[$env]['oauthUserToken'], $payload, false);
        $json = json_decode($response['body']);
        $smarty->assign([
            'NEXT_LINK'=>$json->next,
            'PREV_LINK'=>$json->prev,
            'INVENTORY_TASKS'=>$json->tasks,
            'CURRENT_OFFSET'=>$offset,
        ]);
    }else if(isset($_GET['page']) and $_GET['page'] == 'ebay_specials'){
        $ra_exists = ebay_multi_edit::running_auctions_job_exists();
        if($ra_exists){
            $smarty->assign([
                'ERROR_IN_PROGRESS'=>RUNNING_AUCTIONS_JOB_EXISTS
            ]);
        }
        if(!$ra_exists){
            
            $files = basics::get_directory_content($specials_path.DIRECTORY_SEPARATOR);
            $uploaded_files = [];
            foreach($files as $file){
                if(strpos($file,'.gz-')){
                    $uploaded_files[] = $file;
                }
            }
            // DATENDATEI WURDE BEI EBAY HOCHGELADEN, ABER DAS RESULTAT NOCH NICHT
            // VERARBEITET
            if(!sizeOf($uploaded_files)){   
                $normal_auctions = [];
                $variation_auctions = [];
                // REVISE
                $auctions = specials_ebay_revise::get_items_by_status(0,0);
                if(sizeOf($auctions)){
                    foreach($auctions as $serID){
                        $ser = new specials_ebay_revise($serID);
                        $ser->get_revise_auction_data_array($normal_auctions, $variation_auctions,true);
                    }
                }
                // DE-REVISE
                $auctions = specials_ebay_revise::get_items_by_status(1, 1);
                if(sizeOf($auctions)){
                    foreach($auctions as $serID){
                        $ser = new specials_ebay_revise($serID);
                        $ser->get_revise_auction_data_array($normal_auctions, $variation_auctions,true);
                    }
                }
            

                $created_specials_data_files = basics::get_directory_content($specials_path.DIRECTORY_SEPARATOR);
                if(sizeOf($created_specials_data_files)){
                    $smarty->assign([
                        'SPECIAL_FILES'=>$created_specials_data_files,
                        'BUTTON_UPLOAD'=>BUTTON_UPLOAD_REVISE_FILE,
                        'SPECIALS_PRICE_REVISE_LINK'=>xtc_href_link(basename(__FILE__),'action=process_specials_upload_file'),
                    ]);
                }else{
                    $smarty->assign([
                        'FORM'=>xtc_draw_form('ebay_specials_revise_form',basename(__FILE__),'action=ebay_specials_revise','POST'),
                    ]);
                }
            }else{
                $smarty->assign('RESULTS_AVAILABLE','1');
            }
            $smarty->assign([
                'PAGE_HEADING_EBAY_SPECIALS_REVISE'=>PAGE_HEADING_EBAY_SPECIALS_REVISE,
                'PAGE_HEADING_EBAY_SPECIALS_REVISE'=>PAGE_HEADING_EBAY_SPECIALS_REVISE,
                'INFO_EBAY_SPECIALS_REVISE_NORMAL'=>INFO_EBAY_SPECIALS_REVISE_NORMAL,
                'INFO_EBAY_SPECIALS_REVISE_VARIATIONS'=>INFO_EBAY_SPECIALS_REVISE_VARIATIONS,
                'AUCTIONS'=>$normal_auctions,
                'VARIATION_AUCTIONS'=>$variation_auctions,
                'MODE'=>$mode,
                'EBAY_PRICE_REVISE_UPLOAD_PROCESSING'=>EBAY_PRICE_REVISE_UPLOAD_PROCESSING,
            ]);
            
        }
    }else{
        $up_auction_tasks = [];
        $up_tasks = [];
        // GET
        $up_limit = 25;
        $up_offset = (isset($_GET['up_offset'])) ? (int)xtc_db_input($_GET['up_offset']) : 0;
        $up_feedType = "LMS_REVISE_FIXED_PRICE_ITEM";
        $api_baselink = ($env == 'sandbox') ? 'api.sandbox.ebay.com' : 'api.ebay.com';
        $link = sprintf(
                "https://%s/sell/feed/v1/task?feed_type=%s&limit=%d&offset=%d&look_back_days=%d",
                $api_baselink,$up_feedType,$up_limit,($up_offset*$up_limit),$look_back_days
        );
        $payload = '';
        $response = ebay_api_feed_call($link,$config[$env]['oauthUserToken'], $payload, false);
        $up_json = json_decode($response['body']);
        foreach($up_json->tasks as $k=>$upj){
            if(is_dir($save_path.str_replace('-','_',$upj->taskId).'-DONE')){
                $up_json->tasks[$k]->yes_processed = true;
            }elseif(specials_ebay_revise::is_task_allocated($upj->taskId)){
                $up_json->tasks[$k]->is_special = true;
            }
        }
        $smarty->assign([
            'UP_NEXT_LINK'=>$up_json->next,
            'UP_PREV_LINK'=>$up_json->prev,
            'UPLOAD_TASKS'=>$up_json->tasks,
            'CURRENT_UP_OFFSET'=>$up_offset,
        ]);
        
        $up_auction_offset = (isset($_GET['up_auction_offset'])) ? (int)xtc_db_input($_GET['up_auction_offset']) : 0;
        $up_auction_feedType = "LMS_REVISE_ITEM";
        $link = sprintf(
                "https://%s/sell/feed/v1/task?feed_type=%s&limit=%d&offset=%d&look_back_days=%d",
                $api_baselink,$up_auction_feedType,$up_limit,($up_auction_offset*$up_limit),$look_back_days
        );
        $payload = '';
        $response = ebay_api_feed_call($link,$config[$env]['oauthUserToken'], $payload, false);
        $up_json = json_decode($response['body']);
        foreach($up_json->tasks as $k=>$upj){
            if(is_dir($save_path.str_replace('-','_',$upj->taskId).'-DONE')){
                $up_json->tasks[$k]->yes_processed = true;
            }elseif(specials_ebay_revise::is_task_allocated($upj->taskId)){
                $up_json->tasks[$k]->is_special = true;
            }
        }
        $smarty->assign([
            'UP_AUCTION_NEXT_LINK'=>$up_json->next,
            'UP_AUCTION_PREV_LINK'=>$up_json->prev,
            'UPLOAD_AUCTION_TASKS'=>$up_json->tasks,
            'CURRENT_UP_AUCTION_OFFSET'=>$up_auction_offset,
        ]);
        
        if(isset($_SESSION['price_revise_created'])){
            $_SESSION['price_revise_created'] = null;
            unset($_SESSION['price_revise_created']);
            $smarty->assign('START_MESSAGE',HELP_REVISE_FILE_CREATED);
        }
    }
    
    yes_draw_pre_header();
    yes_draw_header(TITLE);

    $smarty->assign(array(
        'language_path'=>DIR_FS_CATALOG.'lang/german/admin/german.conf',
        'FILES'=>$files,
        'ACTION'=>$action,
        'HEADING_TITLE'=>HEADING_TITLE,
        'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
        'EBAY_USER_SELECT'=> xtc_draw_pull_down_menu('ebay_user',xtc_get_ebay_users(),EBAY_USER),
        'UPLOAD_FILE'=>(is_file(\main::get_exportdata_path().'LMS_MULTI_EDIT_DATAFILES.zip')),
        'PAGE'=>(isset($_GET['page'])) ? $_GET['page'] : '',
        'IS_ADMIN'=>($_SESSION['customer_id'] == 1)?'1':'',
        'INTRO_EBAY_REVISE_REFRESH'=>INTRO_EBAY_REVISE_REFRESH,
    ));
    
    $smarty->display('ebayapi_sdk_feeds.html');
    require(DIR_WS_INCLUDES . 'footer.php');
    require(DIR_WS_INCLUDES . 'application_bottom.php');
}
