<?php
/* --------------------------------------------------------------
   $Id: orders_edit.php,v 1.1

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(orders.php,v 1.27 2003/02/16); www.oscommerce.com
   (c) 2003	 nextcommerce (orders.php,v 1.7 2003/08/14); www.nextcommerce.org

   Released under the GNU General Public License

   To do: Rabatte ber�cksichtigen
   --------------------------------------------------------------*/

  
$allow_tax = '1';  	// sollte irgendwann mal feststehen dass wir lieferantenbestellungen ohne
// MwSt brauchen, dann pro lieferant einbauen - mario -
 
require('includes/application_top.php');  
require_once(DIR_WS_CLASSES.'product.php');
require_once(DIR_WS_CLASSES.'distributor.php');
require_once(DIR_WS_CLASSES.'distributor_order.php');
require_once(DIR_WS_CLASSES.'distributor_order_proposal.php');
require_once(DIR_FS_INC . 'xtc_get_parent_categories.inc.php');
require_once(DIR_FS_INC . 'xtc_get_product_path.inc.php');
require_once(DIR_FS_INC.'xtc_oe_get_tax_rate.inc.php');
require_once(DIR_FS_INC.'xtc_oe_get_price_i_tax.inc.php');



if(isset($_REQUEST['use_meldebestand'])){
	switch($_REQUEST['use_meldebestand']){
		case 1:
			$_SESSION['distributor_orders_proposal_use_meldebestand'] = 1;
			break;
		default:
			unset($_SESSION['distributor_orders_proposal_use_meldebestand']);
	}
}

class product_proposal
{
	var $products_id;
	var $in_orders;
	var $products_quantity;
	var $products_meldebestand;
	var $products_model;
	var $bestellt;
	var $diff;
	var $products_name;
	public function getProducts_id() {
		return $this->products_id;
	}

	public function setProducts_id($products_id) {
		$this->products_id = $products_id;
	}

	public function addIn_orders($value) {
		$this->in_orders += $value;
	}
	public function getIn_orders() {
		return $this->in_orders;
	}

	public function setIn_orders($in_orders) {
		$this->in_orders = (int)$in_orders;
	}

	public function getProducts_quantity() {
		return $this->products_quantity;
	}

	public function setProducts_quantity($products_quantity) {
		$this->products_quantity = $products_quantity;
	}

	public function getProducts_meldebestand() {
		return $this->products_meldebestand;
	}

	public function setProducts_meldebestand($products_meldebestand) {
		$this->products_meldebestand = $products_meldebestand;
	}

	public function getProducts_model() {
		return $this->products_model;
	}

	public function setProducts_model($products_model) {
		$this->products_model = $products_model;
	}

	public function getBestellt() {
		return $this->bestellt;
	}

	public function setBestellt($bestellt) {
		$this->bestellt = (int)$bestellt;
	}
	
	public function getDiff() {
		return $this->diff;
	}

	public function setDiff($diff) {
		$this->diff = $diff;
	}

	public function getProducts_name() {
		return $this->products_name;
	}

	public function setProducts_name($products_name) {
		$this->products_name = $products_name;
	}

	public function __construct($array){
		$this->setProducts_id($array['products_id']);
//		$this->setDiff($array['products_meldebestand']-$array['products_quantity']-$array['anz']);
		$this->setProducts_name( xtc_get_products_name($array['products_id']) );
		$this->setIn_orders($array['anz']);
		$this->setBestellt($array['bestellt']);
		$this->setProducts_model($array['products_model']);
		$this->setProducts_quantity($array['products_quantity']);
		$this->setProducts_meldebestand($array['products_meldebestand']);
	}
	
	public function get_proposal_values(){
		$this->setDiff( $this->getProducts_meldebestand() - $this->getProducts_quantity() - $this->getIn_orders() );
	}
	
	public function get_array_values(){
		return array(
			'products_id'=>$this->getProducts_id(),
			'diff'=>$this->getDiff(),
			'products_model'=>$this->getProducts_model(),
			'products_name'=>$this->getProducts_name(),
			'products_meldebestand'=>$this->getProducts_meldebestand(),
			'anz'=>$this->getIn_orders(),
			'bestellt'=>$this->getBestellt(),
			'products_quantity'=>$this->getProducts_quantity()
		);
	}
}

// PHP8 Kompatibel 2024/11
function masort(&$data, $sortby)
{
   static $sort_funcs = array();
   if (empty($sort_funcs[$sortby])) {
        if (version_compare(PHP_VERSION, '8', '>=')) {
            // Extrahiere die benötigten Informationen für die Sortierung
            $keys = explode(',', $sortby);
        
            // Erstelle eine normale Funktion mit den extrahierten Informationen
            $sort_func = function($a, $b) use ($keys) {
                foreach ($keys as $key) {
                    $value_a = isset($a[$key]) ? $a[$key] : '';
                    $value_b = isset($b[$key]) ? $b[$key] : '';

                    if ($value_a == $value_b) {
                        continue;
                    }

                    if (is_numeric($value_a)) {
                        return ($value_a < $value_b) ? -1 : 1;
                    } else {
                        return strcasecmp($value_a, $value_b);
                    }
                }

                return 0;
            };
            $sort_funcs[$sortby] = $sort_func;
       }else{
            $code = "\$c=0;";
            foreach (explode(',', $sortby) as $key) {
                $array = array_pop($data);
                array_push($data, $array);
                if(is_numeric($array[$key])){
                    $code .= "if ( \$c = ((\$a['$key'] == \$b['$key']) ? 0:((\$a['$key'] < \$b['$key']) ? +1 : -1 )) );";
                }else{
                    $code .= "if ( (\$c = strcasecmp(\$a['$key'],\$b['$key'])) != 0 ) return \$c;\n";
                }
            }
            $code .= 'return $c;';
            $sort_func = $sort_funcs[$sortby] = create_function('$a, $b', $code);
       }
   } else {
        if (version_compare(PHP_VERSION, '8', '<')) {
            $sort_func = $sort_funcs[$sortby];
        }
   }
   if (version_compare(PHP_VERSION, '8', '<')) {
        $sort_func = $sort_funcs[$sortby];
        uasort($data, $sort_func);
   }else{
        uasort($data, $sort_funcs[$sortby]);       
   }
}
$invalid_orders_statuses = array(ORDERS_STATUS_ABGESCHLOSSEN, ORDERS_STATUS_VERSENDET, ORDERS_STATUS_STORNIERT, ORDERS_STATUS_OFFER);
$valid_orders_statuses = array();
if(isset($_REQUEST['valid_orders_status']) and $_REQUEST['valid_orders_status'] > 0){
    $valid_orders_statuses = array( (int)xtc_db_input($_REQUEST['valid_orders_status']) );
}
$order_source_filter_sql = (sizeOf($valid_orders_statuses)) ? sprintf('orders_status IN ( %s )',implode(',',$valid_orders_statuses)) : sprintf('orders_status NOT IN ( %s )',implode(',',$invalid_orders_statuses));
function _get_products_data($products_id){
    global $order_source_filter_sql;
	$dquery = xtc_db_query(sprintf(
		"SELECT (SUM(dop.products_quantity)-SUM(dop.qty_rueckbuch)) as bestellt FROM distributor_orders_products dop, distributor_orders do WHERE	do.distributor_orders_id=dop.distributor_orders_id AND do.orders_status IN(2) and dop.products_id='%s'",
		$products_id
	));
	$drecord = xtc_db_fetch_array($dquery);
	$query = xtc_db_query(sprintf("SELECT SUM(op.products_quantity) as anz,p.products_quantity,p.products_meldebestand,p.products_model
		FROM products p LEFT JOIN orders_products op USING(products_id)
		LEFT JOIN orders o
		USING ( orders_id )
		WHERE (op.products_id IS NOT NULL AND %s AND p.products_id=%s) ",
		$order_source_filter_sql,
		$products_id
	));
	$record = xtc_db_fetch_array($query);
	$record['bestellt'] = $drecord['bestellt'];
	return $record;
}

$catID = (isset($_REQUEST['category_id'])) ? (int)xtc_db_input($_REQUEST['category_id']) : 0;

$admin_access = main::get_admin_access();

// initiate template engine for mail
$smarty = new yesSmarty;
// dont allow cache
$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$sort_asc = true;
if(isset($_REQUEST['order_by'])){
	$order_by = $_REQUEST['order_by'];
	$parts = explode(' ',$_REQUEST['order_by']);
	if(sizeOf($parts)>1){
		list($order_by,$direction) = $parts;
		if(strtolower($direction) == 'desc')
			$sort_asc = false;
	}
}else{
	$order_by = 'pd.products_name';
}
$smarty->assign('SUBMITTED_ORDER_BY',$order_by);
$smarty->assign('SUBMITTED_ORDER_DIRECTION',(($sort_asc)?'asc':'desc'));
$buttons = array();
if(isset($_REQUEST['dID']) and $_REQUEST['dID'] != ''){
    $buttons[] = array('text'=>BUTTON_GENERATE_ORDER,
	'link'=>xtc_href_link('distributor_orders_proposal.php',xtc_get_all_get_params(array('action')).'action=generate_order_confirm'),
	'auth'=>true,
	'lbOn'=>false
    );
}

$smarty->assign(array(
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
	'EXT_POPUP_WIDTH'=>EXT_POPUP_WIDTH,
	'EXT_POPUP_HEIGHT'=>EXT_POPUP_HEIGHT,
	'PAGE_HEADING'=>PAGE_HEADING,
	'FORM_END'=>'</form>',
	'TEXT_MELDEBESTAND'=>TEXT_MELDEBESTAND,
	'QTY_PHYS'=>QTY_PHYS,
	'QTY_PHYS_LONG'=>QTY_PHYS_LONG,
	'SELLS_4WEEKS'=>SELLS_4WEEKS,
	'SELLS_3MONTH'=>SELLS_3MONTH,
	'TEXT_VIEW_ALLOCATED_ITEMS'=>TEXT_VIEW_ALLOCATED_ITEMS,
	'TEXT_GOTO_WEBSITE'=>TEXT_GOTO_WEBSITE,
	'TEXT_SELECT_PRODUCTS_FROM_DISTRIBUTOR'=>TEXT_SELECT_PRODUCTS_FROM_DISTRIBUTOR,
	'TEXT_ALL_PRODUCTS'=>TEXT_ALL_PRODUCTS,
	'TEXT_SELECT_PRODUCTS_ID'=>TEXT_SELECT_PRODUCTS_ID,
	'TEXT_NO_DISTRIBUTORS_SAVED'=>TEXT_NO_DISTRIBUTORS_SAVED,
	'TEXT_INTRO_ABVERKAEUFE'=>TEXT_INTRO_ABVERKAEUFE,
	'TEXT_LIST_WITHOUT_ORDERS'=>TEXT_LIST_WITHOUT_ORDERS,
	'TEXT_LIST_WITHOUT_ORDERS_INTRO'=>TEXT_LIST_WITHOUT_ORDERS_INTRO,
	'USE_MELDEBESTAND'=>((isset($_SESSION['distributor_orders_proposal_use_meldebestand']) and $_SESSION['distributor_orders_proposal_use_meldebestand'] == 1)?1:0)
));
$smarty->assign('SORT_BASE_URL',xtc_href_link('distributor_orders_proposal.php',xtc_get_all_get_params(array('order_by'))));
$smarty->assign('USE_MELDEBESTAND_BASE_URL',xtc_href_link('distributor_orders_proposal.php',xtc_get_all_get_params(array('use_meldebestand'))));
$smarty->assign('SEARCHFORM',xtc_draw_form('dist_search','distributor_orders_proposal.php',xtc_get_all_get_params(array('psearch')),'GET','class="yesForm"'));
$smarty->assign('INPUT_PSEARCH',xtc_draw_input_field('psearch',((isset($_REQUEST['psearch']))?$_REQUEST['psearch']:''),'size="4" maxlength="8"'));
$smarty->assign('DIDFORM',xtc_draw_form('dist_qck','distributor_orders_proposal.php?'.xtc_get_all_get_params(array('dID')),'','GET','class="yesForm"'));
$action = $_GET['action']??'';
switch($action){
    case "address_edit":
        // yes accounting
        if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_distributor_orders_edit_address'] == '1')) {
        }else{
            $messageStack->add_session(MSG_ERROR_AUTH_ADDRESS_EDIT,'error');
            xtc_redirect(xtc_href_link('distributor_orders_edit.php',xtc_get_all_get_params(array('action'))));
        }
	  
        require_once(DIR_FS_ADMIN . 'includes/classes/distributor_order.php');
        $sql_data_array = array('distributor_id' => xtc_db_prepare_input($_POST['dID']),
            'distributor_name' => xtc_db_prepare_input($_POST['distributor_name']),
            'distributor_street_address' => xtc_db_prepare_input($_POST['distributor_street_address']),
            'distributor_city' => xtc_db_prepare_input($_POST['distributor_city']),
            'distributor_postcode' => xtc_db_prepare_input($_POST['distributor_postcode']),
            'distributor_country' => xtc_db_prepare_input($_POST['distributor_country']),
            'delivery_company' => xtc_db_prepare_input($_POST['delivery_company']),
            'delivery_name' => xtc_db_prepare_input($_POST['delivery_name']),
            'delivery_street_address' => xtc_db_prepare_input($_POST['delivery_street_address']),
            'delivery_suburb' => xtc_db_prepare_input($_POST['delivery_suburb']),
            'delivery_city' => xtc_db_prepare_input($_POST['delivery_city']),
            'delivery_postcode' => xtc_db_prepare_input($_POST['delivery_postcode']),
            'delivery_country' => xtc_db_prepare_input($_POST['delivery_country']));
        $update_sql_data = array('last_modified' => 'now()');
        $sql_data_array = xtc_array_merge($sql_data_array, $update_sql_data);
        xtc_db_perform('distributor_orders', $sql_data_array, 'update', 'distributor_orders_id = \'' . xtc_db_input($_POST['dpID']) . '\'');
        $order = new distributor_order((int)$_POST['dpID']);
        $order->insert_history(intval($order->info['orders_status']),false, HISTORY_ADDRESS_EDIT);
        $messageStack->add_session(HISTORY_ADDRESS_EDIT, 'success');
        xtc_redirect(xtc_href_link('distributor_orders_edit.php', 'text=address&dID='.$_POST['dID'].'&dpID=' . $_POST['dpID']));
        break;
    case 'generate_order':
        if(!xtc_not_null($_REQUEST['dID'])){
            $messageStack->add_session(MSG_ERROR_EXPORT_NO_DISTRIBUTOR,'error');
            xtc_redirect(xtc_href_link('distributor_orders_proposal.php',xtc_get_all_get_params(array('action'))));
        }
        $dID = (int)xtc_db_prepare_input($_REQUEST['dID']);
        $distributor = new distributor($dID);


        if(!isset($_SESSION['distributor_orders_proposal_use_meldebestand'])){
            $query = xtc_db_query(sprintf("SELECT p.products_id FROM products p 
                LEFT JOIN orders_products op USING(products_id)
                LEFT JOIN orders o
                USING ( orders_id )
                WHERE op.products_id IS NOT NULL AND %s GROUP BY products_id ",
                $order_source_filter_sql
            ));
        }else{
            $query = xtc_db_query("SELECT p.products_id FROM products p WHERE p.products_quantity < p.products_meldebestand");
        }
        while($row = xtc_db_fetch_array($query)){
            $collies = xtc_get_product_collies($row['products_id']);
            if(sizeOf($collies)){
                foreach($collies as $colli){
                    // lieferanteneintrag?
                    $lb_query = xtc_db_query(sprintf("SELECT id FROM products_distributors pd WHERE distributor_id=%s and products_id=%s",
                            $dID,
                            $colli['collie_products_id']
                    ));
                    if(!xtc_db_num_rows($lb_query)){
                            continue;
                    }

                    // BOF ticket 1562 - Uebergabe der Menge via Inputfeld
                    //$record = _get_products_data($row['products_id']);
                    //$set_qty = $record['anz'];
                    $set_qty = (int)xtc_db_input($_REQUEST['quantity'][$row['products_id']]);
                    // EOF ticket 1562 - Uebergabe der Menge via Inputfeld

                    $record = _get_products_data($colli['collie_products_id']);
                    $record['products_id'] = $colli['collie_products_id'];
                    if(!isset($products[ $colli['collie_products_id'] ])){
                            $record['anz'] = $set_qty*$colli['quantity'];
                            $products[ $colli['collie_products_id'] ] = new product_proposal($record);
                    }else{
                            $products[ $colli['collie_products_id'] ]->addIn_orders($colli['quantity']*$record['anz']);
                    }
                }
            }else{
                $lb_query = xtc_db_query(sprintf("SELECT id FROM products_distributors pd WHERE distributor_id=%s and products_id=%s",
                        $dID,
                        $row['products_id']
                ));
                if(!xtc_db_num_rows($lb_query)){
                        continue;
                }
                $record = _get_products_data($row['products_id']);
                $record['products_id'] = $row['products_id'];

                // BOF ticket 1562 - Uebergabe der Menge via Inputfeld
                $record['anz'] = (int)xtc_db_input($_REQUEST['quantity'][$row['products_id']]);
                // EOF ticket 1562 - Uebergabe der Menge via Inputfeld

                if(!isset($products[ $record['products_id'] ])){
                        $products[ $row['products_id'] ] = new product_proposal($record);
                }else{
                        $products[ $row['products_id'] ]->addIn_orders($record['anz']);
                }
            }
        }
        if(!sizeOf($products)){
            $messageStack->add_session(MSG_ERROR_GENERATE_NO_PRODUCTS,'error');
            xtc_redirect(xtc_href_link('distributor_orders_proposal.php',xtc_get_all_get_params(array('action'))));
        }
        $matches = array();
        foreach($products as $pp){
            $matches[ $pp->getProducts_id() ] = $pp->getIn_orders();
        }
        $products = array();
        foreach($matches as $pID => $qty){
            $record = array();
            $product_query = xtc_db_query(sprintf(
                "SELECT pd.products_name, p.products_model 
                 FROM products p LEFT JOIN products_description pd USING(products_id)
                 WHERE p.products_id='%d' AND pd.language_id='%d'",
                $pID,
                $_SESSION['languages_id']
            ));
            $product = xtc_db_fetch_array($product_query);
            $record['order'] = $qty;
            $record['products_id'] = $pID;
            $record['products_tax_class_id'] = yes_eu_oss_get_products_tax_class_id($pID, STORE_COUNTRY);
            $record['products_model'] = $product['products_model'];
            $record['products_name'] = $product['products_name'];
            $products[] = $record;
        }
        if(sizeOf($products) == 0){
            $messageStack->add_session(MSG_ERROR_GENERATE_NO_PRODUCTS,'error');
            xtc_redirect(xtc_href_link('distributor_orders_proposal.php',xtc_get_all_get_params(array('action'))));
        }
        $distributor = new distributor($dID);
        $orders_id = $distributor->new_order();
        foreach($products as $product){
            if(!in_array($product['products_id'],$_REQUEST['products_id'])){
                continue;
            }
            $tax = 0;
            // PRICE NETTO
            $price = xtc_get_price_ek($product['products_id'],'MIN',$dID);
            if($distributor->info['tax_orders'] > 0){
                $tax = xtc_oe_get_tax_rate($product['products_tax_class_id']);
                $tax_divisor = (100+$tax)/100;
                $price = $price * $tax_divisor;
            }

            $final_price = $price * $product['order'];
            $sql_insert_array = array(
                'distributor_orders_id'=>$orders_id,
                'products_id'=>$product['products_id'],
                'products_model'=>$product['products_model'],
                'products_name'=>$product['products_name'],
                'products_price'=>$price,
                'products_discount_made'=>0,
                'final_price'=>$final_price,
                'products_tax'=>$tax,
                'products_quantity'=>$product['order'],
                'allow_tax'=>$distributor->info['tax_orders'],
                'date_added'=>'now()'
            );
            xtc_db_perform('distributor_orders_products',$sql_insert_array);
        }
        $comments = sprintf(HISTORY_GENERATE_ORDER,sizeOf($products));
        $distributor_order = new distributor_order($orders_id);
        $distributor_order->insert_history($distributor_order->info['orders_status'], false, $comments, $_SESSION['customer_id']);
        $distributor_order->recalc();
        $messageStack->add_session($comments,'success');
        xtc_redirect(xtc_href_link('distributor_orders.php','doID='.$orders_id.'&action=edit'));
        break;
    case 'generate_order_confirm':
        if(!isset($_REQUEST['dID'])){
            $messageStack->add_session(MSG_ERROR_EXPORT_NO_DISTRIBUTOR,'error');
            xtc_redirect(xtc_href_link('distributor_orders_proposal.php',xtc_get_all_get_params(array('action'))));
        }
        $dID = (int)xtc_db_prepare_input($_REQUEST['dID']);
        $distributor = new distributor($dID);
        $valid_distributor_orders_statuses = array(2);

        if(!isset($_SESSION['distributor_orders_proposal_use_meldebestand'])){
            $query = xtc_db_query(sprintf("SELECT p.products_id FROM products p 
                LEFT JOIN orders_products op USING(products_id)
                LEFT JOIN orders o
                USING ( orders_id )
                WHERE op.products_id IS NOT NULL AND %s GROUP BY products_id ",
                $order_source_filter_sql
            ));
        }else{
            $query = xtc_db_query("SELECT p.products_id FROM products p WHERE p.products_quantity < p.products_meldebestand");
        }
        while($row = xtc_db_fetch_array($query)){
            $collies = xtc_get_product_collies($row['products_id']);
            if(sizeOf($collies)){
                foreach($collies as $colli){
                    // lieferanteneintrag?
                    $lb_query = xtc_db_query(sprintf("SELECT id FROM products_distributors pd WHERE distributor_id=%s and products_id=%s",
                        $dID,
                        $colli['collie_products_id']
                    ));
                    if(!xtc_db_num_rows($lb_query)){
                        continue;
                    }
                    $record = _get_products_data($row['products_id']);
                    $set_qty = $record['anz'];
                    $record = _get_products_data($colli['collie_products_id']);
                    $record['products_id'] = $colli['collie_products_id'];
                    if(!isset($products[ $colli['collie_products_id'] ])){
                        $record['anz'] = $set_qty*$colli['quantity'];
                        $products[ $colli['collie_products_id'] ] = new product_proposal($record);
                    }else{
                        $products[ $colli['collie_products_id'] ]->addIn_orders($colli['quantity']*$record['anz']);
                    }
                }
            }else{
                $lb_query = xtc_db_query(sprintf("SELECT id FROM products_distributors pd WHERE distributor_id=%s and products_id=%s",
                    $dID,
                    $row['products_id']
                ));
                if(!xtc_db_num_rows($lb_query)){
                    continue;
                }
                $record = _get_products_data($row['products_id']);
                $record['products_id'] = $row['products_id'];
                if(!isset($products[ $record['products_id'] ])){
                    $products[ $row['products_id'] ] = new product_proposal($record);
                }else{
                    $products[ $row['products_id'] ]->addIn_orders($record['anz']);
                }
            }
        }
        if(!sizeOf($products)){
            $messageStack->add_session(MSG_ERROR_GENERATE_NO_PRODUCTS,'error');
            xtc_redirect(xtc_href_link('distributor_orders_proposal.php',xtc_get_all_get_params(array('action'))));
        }
        $matches = array();
        foreach($products as $pp){
            $matches[ $pp->getProducts_id() ] = $pp->getIn_orders();
        }
        $products = array();
        foreach($matches as $pID => $qty){
            $record = array();
            $SQ = new products_quantity($pID);
            $pqty = $SQ->get_products_total_qty();
            $remove_qty_rueckbuch = true;
            $ordered = $distributor->get_distributor_orders_quantity($pID, $valid_distributor_orders_statuses,$remove_qty_rueckbuch);
            $needed = ($pqty-$qty)-(-$ordered);

            if($needed < $SQ->get_meldebestand()){
                $product_query = xtc_db_query(sprintf(
                    "SELECT pd.products_name, p.products_model 
                     FROM products p LEFT JOIN products_description pd USING(products_id)
                     WHERE p.products_id='%s' AND pd.language_id='%s'",
                    $pID,
                    $_SESSION['languages_id']
                ));
                /**
                 * Hier mal nachsehen ob $qty der richtige parameter ist
                 */
                $DOP = new distributor_order_proposal($pID,$SQ,$qty,-1,$_SESSION['languages_id']);
                if($DOP->get_db_values()){
                    $_product = $DOP->get_array();

                    // ABVERKAEUFE ERMITTELN
                    $time1 = time()-(60*60*24*28); // 4 wochen
                    $time1 = yes_strftime('%Y-%m-%d',$time1).' 00:00:00';
                    $_product['verk1'] = $DOP->get_sales_stats($time1);

                    $time2 = time()-(60*60*24*28*3); // 3 mon
                    $time2 = yes_strftime('%Y-%m-%d',$time2).' 00:00:00';
                    $_product['verk2'] = $DOP->get_sales_stats($time2);
                    $_product['meldebestand'] = $SQ->get_meldebestand();
                    $_product['needed'] = $needed;
                    $products[] = $_product;
                }
            } // end if needed < meldebestand
        } // end foreach matches
        if(!sizeOf($products)){
            $messageStack->add_session(MSG_ERROR_GENERATE_NO_PRODUCTS,'error');
            xtc_redirect(xtc_href_link('distributor_orders_proposal.php',xtc_get_all_get_params(array('action'))));
        }
        $distributor = new distributor($dID);
        foreach($products as $pi=>$product){
            $tax = 0;
            // PRICE NETTO
            $price = xtc_get_price_ek($product['products_id'],'MIN',$dID);
            if($distributor->info['tax_orders'] > 0){
                $products_tax_class_id = yes_eu_oss_get_products_tax_class_id($product['products_id'], STORE_COUNTRY);
                $tax = xtc_oe_get_tax_rate($products_tax_class_id);
                $tax_divisor = (100+$tax)/100;
                $price = $price * $tax_divisor;
            }

            $final_price = $price * $product['order'];
            $products[$pi]['products_price'] = number_format($price,2,'.','');
            $products[$pi]['final_price'] = number_format($final_price,2,'.','');
            $products[$pi]['order'] = $product['meldebestand']-$product['needed'];
        }
        $smarty->assign('products',$products);
        $smarty->assign('confirm',1);
        $smarty->assign('FORM',xtc_draw_form('confirm_order','distributor_orders_proposal.php',xtc_get_all_get_params(array('action')).'action=generate_order'));
        $smarty->assign('CAPTION_CONFIRM',sprintf(CAPTION_CONFIRM,xtc_get_distributor_name($_REQUEST['dID'])));
        $html = $smarty->fetch('distributor_orders_proposal.html');
        $display_products = $products;
        break;
} // end switch action

$distributors_array = array();
$distributors_query = xtc_db_query("SELECT id,name FROM distributors ORDER BY name");
while($distributors = xtc_db_fetch_array($distributors_query)){
    $distributors_array[] = array('id'=>$distributors['id'],'text'=>$distributors['name']);
}
yes_draw_pre_header();
yes_draw_header(TITLE);
?>
<table border="0" width="100%" cellspacing="0" cellpadding="2">
<tr>
	<td width="100%" valign="top">
<?php
if(!isset($html) or $html == ''){
	$limit = MAX_DISPLAY_SEARCH_RESULTS_ADMIN;
	$start = (isset($_REQUEST['page']))?$_REQUEST['page']*$limit:0;
	$end = $start+$limit;
	$products = array();
	if(!isset($_REQUEST['order_by'])){
            $order_by = ' ORDER BY p.products_id';
	}else{
            $order_by = ' ORDER BY '.xtc_db_input($_REQUEST['order_by']);
	}
	if(isset($_REQUEST['psearch'])){
            if(!isset($_SESSION['distributor_orders_proposal_use_meldebestand'])){
                $query = xtc_db_query(sprintf("SELECT p.products_id FROM products p 
                    LEFT JOIN orders_products op USING(products_id)
                    LEFT JOIN orders o
                    USING ( orders_id )
                    WHERE op.products_id IS NOT NULL AND %s AND p.products_id='%s' GROUP BY products_id ",
                    $order_source_filter_sql,
                    (int)xtc_db_input($_REQUEST['psearch'])
                ));
            }else{
                $query = xtc_db_query(sprintf("SELECT p.products_id FROM products p WHERE p.products_id='%s' AND p.products_quantity < p.products_meldebestand",
                        (int)xtc_db_input($_REQUEST['psearch'])
                ));
            }
	}else{
            if($catID > 0){
                $valid_categories = array($catID);
                yes_get_subcategories($valid_categories, $catID);
            }
            if(!isset($_SESSION['distributor_orders_proposal_use_meldebestand'])){
                if($catID > 0){
                    $query = xtc_db_query(sprintf("SELECT p.products_id FROM products p 
                            LEFT JOIN products_to_categories p2c USING(products_id) 
                            LEFT JOIN orders_products op USING(products_id)
                            LEFT JOIN orders o
                            USING ( orders_id )
                            WHERE op.products_id IS NOT NULL AND %s AND p2c.categories_id IN(%s) GROUP BY products_id ",
                            $order_source_filter_sql,
                            implode(',',$valid_categories)
                    ));
                }else{
                    $query = xtc_db_query(sprintf("SELECT p.products_id FROM products p 
                            LEFT JOIN orders_products op USING(products_id)
                            LEFT JOIN orders o
                            USING ( orders_id )
                            WHERE op.products_id IS NOT NULL AND %s GROUP BY products_id ",
                            $order_source_filter_sql
                    ));
                }
            }else{
                if($catID > 0){
                    $query = xtc_db_query(sprintf(
                            "SELECT p.products_id FROM products p LEFT JOIN products_to_categories p2c USING(products_id)  WHERE p.products_quantity < p.products_meldebestand AND p2c.categories_id IN(%s)",
                            implode(',',$valid_categories)
                    ));
                }else{
                    $query = xtc_db_query(
                            "SELECT p.products_id FROM products p WHERE p.products_quantity < p.products_meldebestand"
                    );
                }
            }
	}
	while($row = xtc_db_fetch_array($query)){
		$collies = xtc_get_product_collies($row['products_id']);
		if(sizeOf($collies)){
			foreach($collies as $colli){
				// lieferanteneintrag?
				if(isset($_REQUEST['dID']) and $_REQUEST['dID'] > 0){
					$lb_query = xtc_db_query(sprintf("SELECT id FROM products_distributors pd WHERE distributor_id=%s and products_id=%s",
						(int)xtc_db_input($_REQUEST['dID']),
						$colli['collie_products_id']
					));
				}else{
					$lb_query = xtc_db_query(sprintf("SELECT id FROM products_distributors pd WHERE products_id=%s",
						$colli['collie_products_id']
					));
				}
				if(!xtc_db_num_rows($lb_query)){
					continue;
				}
				$record = _get_products_data($row['products_id']);
				$set_qty = $record['anz'];

				$record = _get_products_data($colli['collie_products_id']);
				$record['products_id'] = $colli['collie_products_id'];
				if(!isset($products[ $colli['collie_products_id'] ])){
					$record['anz'] = $set_qty*$colli['quantity'];
					$products[ $colli['collie_products_id'] ] = new product_proposal($record);
				}else{
					$products[ $colli['collie_products_id'] ]->addIn_orders($colli['quantity']*$set_qty);
				}
			}
		}else{
			// lieferanteneintrag?
			if(isset($_REQUEST['dID']) and $_REQUEST['dID'] > 0){
				$lb_query = xtc_db_query(sprintf("SELECT id FROM products_distributors pd WHERE distributor_id=%s and products_id=%s",
					(int)xtc_db_input($_REQUEST['dID']),
						$row['products_id']
				));
			}else{
				$lb_query = xtc_db_query(sprintf("SELECT id FROM products_distributors pd WHERE products_id=%s",
					$row['products_id']
				));
			}
			if(!xtc_db_num_rows($lb_query)){
				continue;
			}
			$record = _get_products_data($row['products_id']);
			$record['products_id'] = $row['products_id'];
//			if($record['products_meldebestand'] >= $record['products_quantity']-$record['anz']){
				if(!isset($products[ $record['products_id'] ])){
					$products[ $row['products_id'] ] = new product_proposal($record);
				}else{
					$products[ $row['products_id'] ]->addIn_orders($record['anz']);
				}
//			}
		}
	}
	$matches = array();
	foreach($products as $pp){
		if(!isset($_SESSION['distributor_orders_proposal_use_meldebestand'])){
			if($pp->getProducts_meldebestand() >= $pp->getProducts_quantity() - $pp->getIn_orders() ){
				$pp->get_proposal_values();
				$matches[] = $pp->get_array_values();
			}
		}else{
			$pp->get_proposal_values();
			$matches[] = $pp->get_array_values();
		}
	}
	$products = $matches;
	if(isset($_REQUEST['order_by'])){
		$parts = explode(' ',$_REQUEST['order_by']);
		$field = $parts[0];
		$reverse = ($parts[1] == 'desc') ? true : false;
	}else{
		$field = 'diff';
		$reverse = false;
	}
	if(sizeOf($products))
	    masort($products,$field);


	
	$di_options = array();
	for($i=0;$i<sizeOf($distributors_array);$i++){
		$di  = '<option value="'.$distributors_array[$i]['id'].'"';
		$di .= (isset($_REQUEST['dID']) and $_REQUEST['dID'] == $distributors_array[$i]['id']) ? ' SELECTED' : '';
		$di .= '>'.$distributors_array[$i]['text'].'</option>';
		$di_options[] = $di;
	}
	$smarty->assign('di_options',$di_options);

	$smarty->assign('SORT_MELDEBESTAND',"<table width=100% border='0' cellpadding='0' cellspacing='0'><tR><td class='main'><font style='font-size:10px;'><b>Meldebestand</b></font></td></tr><tr><td><img src='images/updown.gif' border='0' usemap='#updown1'></td></tr></table><map name='updown1'><area shape='rect' coords='15,0,31,7' alt='Absteigend sortieren' href='".xtc_href_link('distributor_orders_proposal.php',xtc_get_all_get_params(array('order_by')).'order_by=p.products_meldebestand%20DESC')."'><area alt='Aufsteigend sortieren' shape='rect' coords='0,0,14,7' href='".xtc_href_link('distributor_orders_proposal.php',xtc_get_all_get_params(array('order_by')).'order_by=p.products_meldebestand%20ASC')."'></map>");
	$smarty->assign('SORT_PID',"<table width=100% border='0' cellpadding='0' cellspacing='0'><tR><td class='main'><font style='font-size:10px;'><b>pID</b></font></td></tr><tr><td><img src='images/updown.gif' border='0' usemap='#updown2'></td></tr></table><map name='updown2'><area shape='rect' coords='15,0,31,7' alt='Absteigend sortieren' href='".xtc_href_link('distributor_orders_proposal.php',xtc_get_all_get_params(array('order_by')).'order_by=p.products_id%20DESC')."'><area alt='Aufsteigend sortieren' shape='rect' coords='0,0,14,7' href='".xtc_href_link('distributor_orders_proposal.php',xtc_get_all_get_params(array('order_by')).'order_by=p.products_id%20ASC')."'></map>");
	$smarty->assign('SORT_TITLE',"<table width=100% border='0' cellpadding='0' cellspacing='0'><tR><td class='main'><font style='font-size:10px;'><b>Produkttitel</b></font></td></tr><tr><td><img src='images/updown.gif' border='0' usemap='#updown3'></td></tr></table><map name='updown3'><area shape='rect' coords='15,0,31,7' alt='Absteigend sortieren' href='".xtc_href_link('distributor_orders_proposal.php',xtc_get_all_get_params(array('order_by')).'order_by=products_name%20DESC')."'><area alt='Aufsteigend sortieren' shape='rect' coords='0,0,14,7' href='".xtc_href_link('distributor_orders_proposal.php',xtc_get_all_get_params(array('order_by')).'order_by=products_name%20ASC')."'></map>");
	$smarty->assign('SORT_BESTELLT',"<table width=100% border='0' cellpadding='0' cellspacing='0'><tR><td class='main'><font style='font-size:10px;'><b>Produkttitel</b></font></td></tr><tr><td><img src='images/updown.gif' border='0' usemap='#updown3'></td></tr></table><map name='updown3'><area shape='rect' coords='15,0,31,7' alt='Absteigend sortieren' href='".xtc_href_link('distributor_orders_proposal.php',xtc_get_all_get_params(array('order_by')).'order_by=bestellt%20DESC')."'><area alt='Aufsteigend sortieren' shape='rect' coords='0,0,14,7' href='".xtc_href_link('distributor_orders_proposal.php',xtc_get_all_get_params(array('order_by')).'order_by=bestellt%20ASC')."'></map>");

	$dops_mode = false;
	$dops_total = 0;
	$display_products = array();
	foreach($products as $open){
		$product = $open;
		$product['name'] = $open['products_name'];
		if(!isset($_REQUEST['dID']) or $_REQUEST['dID'] == ''){
			$dnumbers_query = xtc_db_query("SELECT pd.distributor_products_number,pd.distributor_products_link,d.name,d.id FROM products_distributors pd LEFT join distributors d ON d.id=pd.distributor_id WHERE pd.products_id='".$open['products_id']."'");
		}else{
			$dnumbers_query = xtc_db_query("SELECT pd.distributor_products_number,pd.distributor_products_link,d.name,d.id FROM products_distributors pd LEFT join distributors d ON d.id=pd.distributor_id WHERE pd.products_id='".$open['products_id']."' and pd.distributor_id='".xtc_db_input($_REQUEST['dID'])."'");
		}
		$dnumbers = array();
		$p = new product($open['products_id']);
		while($dnumber = xtc_db_fetch_array($dnumbers_query)){
			$distributor_products_edit_link = xtc_href_link('distributor.php','action=products&dID='.$dnumber['id']);
			$dprices = $p->get_distributor_prices($dnumber['id']);
			$dprice_array = array();
			for($i=0;$i<sizeOf($dprices);$i++){
				$dprice_array[] = array(
					'price'=>number_format($dprices[$i]['price'],2,',',''),
					'conditions'=>$dprices[$i]['conditions'] );
			}
			$ordered = 0;
			$ordered_by_query = xtc_db_query("SELECT (SUM(dop.products_quantity)-SUM(dop.qty_rueckbuch)) as bestellt FROM distributor_orders_products dop, distributor_orders do WHERE do.distributor_orders_id=dop.distributor_orders_id AND do.orders_status = 2 and dop.products_id='".$open['products_id']."' and do.distributor_id='".$dnumber['id']."'");
			$ordered_by = xtc_db_fetch_array($ordered_by_query);
			$ordered += $ordered_by['bestellt'];

			$dnumbers[] = array(
				'name'=>$dnumber['name'],
				'number'=>$dnumber['distributor_products_number'],
				'ordered'=>$ordered,
				'distributor_products_link'=>$dnumber['distributor_products_link'],
				'distributor_products_edit_link'=>$distributor_products_edit_link,
				'prices'=>$dprice_array
			);
		}

		$product['dnumbers'] = $dnumbers;

		// in welchen stuecklistenartikeln ist dieses product enthalten
		$in_collies = xtc_get_product_in_collies($open['products_id']);
		if(sizeOf($in_collies)>0){
			$stats_check_array = $in_collies;
		}else{
			$stats_check_array = array(0=>array('products_id'=>$open['products_id'],'quantity'=>1));
		}

		// ABVERKAEUFE ERMITTELN
		$time1 = time()-(60*60*24*28); // 4 wochen
		$time1 = yes_strftime('%Y-%m-%d',$time1).' 00:00:00';
		$time2 = time()-(60*60*24*28*3); // 3 mon
		$time2 = yes_strftime('%Y-%m-%d',$time2).' 00:00:00';
		$valid_stats_orders_statuses = array(ORDERS_STATUS_VERSENDET,ORDERS_STATUS_BEZAHLT,ORDERS_STATUS_ABGESCHLOSSEN);
		foreach($stats_check_array as $pk=>$stat_product){
		    
			$query1 = xtc_db_query("SELECT sum(products_quantity) as summe FROM orders o, orders_products op WHERE o.orders_id=op.orders_id and o.orders_status IN(".implode(',',$valid_stats_orders_statuses).") and o.date_purchased>'".$time1."' and op.products_id='".$stat_product['products_id']."'");
			$res1 = xtc_db_fetch_array($query1);
			if(!isset($product['verk1']))
				$product['verk1'] = 0;
			$product['verk1'] += (int)$res1['summe']*$stat_product['quantity'];

			$query2 = xtc_db_query("SELECT sum(products_quantity) as summe FROM orders o, orders_products op WHERE o.orders_id=op.orders_id and o.orders_status IN(".implode(',',$valid_stats_orders_statuses).") and o.date_purchased>'".$time2."' and op.products_id='".$stat_product['products_id']."'");
			$res2 = xtc_db_fetch_array($query2);
			if(!isset($product['verk2']))
				$product['verk2'] = 0;
			$product['verk2'] += (int)$res2['summe']*$stat_product['quantity'];
		}

		// BESTAND ERMITTELN
		$SQ = new products_quantity((int)$open['products_id']);
		$pqty = $SQ->get_products_total_qty();
		$qtytotal = $SQ->get_gesamtbestand_qty();
		$product['anz'] = $pqty;
		$product['orders'] = xtc_get_products_not_shipped((int)$open['products_id'],$valid_orders_statuses);
		$product['popup_link'] = xtc_href_link('products.php','action=bestand&pID='.$open['products_id']);

		$product['meldebestand'] = $open['products_meldebestand'];

		// LIEFERZEIT
		$shippings = array();
                $shipping_query = xtc_db_query("SELECT dp.shipping_status_id,d.name FROM distributor_product_prices dp,distributors d WHERE products_id='".$open['products_id']."' and dp.distributor_id=d.id and dp.shipping_status_id>0");
                while( $shipping_res = xtc_db_fetch_array($shipping_query) ){
                    $shippings[] = array(
                        'name'=>$shipping_res['name'],
                        'time'=> xtc_get_shipping_status_name($shipping_res['shipping_status_id'])
                    );
                }
		if(sizeOf($shippings)>0){
                    $product['shipping'] = $shippings;
                }

		$product['ordered'] = (int)$open['bestellt'];

		$ok = true;
		if(isset($_GET['null_ordered']) and $_GET['null_ordered'] == '1' and $product['ordered'] > 0){
                    $ok = false;
                }
		if(isset($_GET['ordered']) and $_GET['ordered'] == '1' and $product['ordered'] == 0){
                    $ok = false;
                }

		if(isset($_GET['open_orders']) and $_GET['open_orders'] == '1' and $product['orders'] == 0){
                    $ok = false;
                }

		if($ok){
                    $display_products[] = $product;
                }
	}
	$total_products = sizeOf($display_products);
	$page = (isset($_REQUEST['page'])) ? (int)$_REQUEST['page'] : 0;
	$start_string = $page*MAX_DISPLAY_SEARCH_RESULTS_ADMIN;
	$end_string = $start_string + MAX_DISPLAY_SEARCH_RESULTS_ADMIN;
	if($end_string > $total_products){
	    $end_string = $total_products;
	}
	$products = array();
	foreach($display_products as $k=>$prod){
		if( ($k >= $start_string or $start_string == 0) and $k < $end_string){
			$products[] = $prod;
		}
	}
	$smarty->assign('products',$products);
	
	$start_counter = $page * MAX_DISPLAY_SEARCH_RESULTS_ADMIN;
	$max_end = MAX_DISPLAY_SEARCH_RESULTS_ADMIN-(MAX_DISPLAY_SEARCH_RESULTS_ADMIN-$total_products);
	$end_counter = ($start_counter + $max_end - MAX_DISPLAY_SEARCH_RESULTS_ADMIN);
	$pager_input = '';
	$pager_info = sprintf(TEXT_DISPLAY_NUMBER_OF_ITEMS,$start_string,$end_string,$total_products);

	if($total_products > 0){
		$page_diff = $total_products % MAX_DISPLAY_SEARCH_RESULTS_ADMIN;
		$total_pages = ($total_products - $page_diff)/MAX_DISPLAY_SEARCH_RESULTS_ADMIN;
		if($page_diff > 0)
			$total_pages = $total_pages+1;
		$pages_options = array();
		for($tpi=0;$tpi<$total_pages;$tpi++){
			$pages_options[] = array('id'=>$tpi,'text'=>$tpi+1);
		}
		if($total_pages > 0){
			$pager_input = xtc_draw_form('pager','distributor_orders_proposal.php','','GET' );
			$input_string = xtc_draw_pull_down_menu('page',$pages_options,$page,'onchange="document.forms[\'pager\'].submit();"').
				xtc_draw_hidden_field('open_orders', ((isset($_REQUEST['open_orders']))?$_REQUEST['open_orders']:'') ).
				xtc_draw_hidden_field('dID', ((isset($_REQUEST['dID']))?$_REQUEST['dID']:'') );
			$pager_input .= sprintf(TEXT_RESULT_PAGE,$input_string.'</form>',$total_pages);
		}
	}
	$smarty->assign('split',$pager_info);
	$smarty->assign('split_input',$pager_input);
}
$invalid_orders_statuses_str_array = array();
foreach($invalid_orders_statuses as $iv){
    $invalid_orders_statuses_str_array[] = xtc_get_orders_status_name($iv);
}
$invalid_orders_statuses_str = count($invalid_orders_statuses_str_array) <= 1 ? reset($invalid_orders_statuses_str_array) : join(', ', array_slice($invalid_orders_statuses_str_array, 0, -1)) . " oder " . end($invalid_orders_statuses_str_array); 
//$invalid_orders_statuses_str = implode(', ',$invalid_orders_statuses_str_array);

$cat_select = \YES4Trade\Model\category::get_categories_tree_select([
    'return_function'=>sprintf('$(\'input[name="category_id"]\').val(id);'),
    'ALL_ITEMS_SELECTABLE'=>'true'
], new \yesSmarty());
$smarty->assign(array(
    'CATEGORY_FILTER_INPUT'=>$cat_select
        . '<br />Category ID'
        . xtc_draw_input_field('category_id',$_GET['category_id']??'','size="8"',false,'number'),
    'INPUT_ORDERS_STATUS'=>xtc_draw_pull_down_menu('valid_orders_status',  array_merge(array(array('id'=>'','text'=>TEXT_SELECT)),xtc_get_orders_status()),current($valid_orders_statuses)),
    'ORDERS_STATUS_BASELINK'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('valid_orders_status'))),
    'TEXT_ORDER_FILTER_INTRO1'=>sprintf(TEXT_ORDER_FILTER_INTRO1,$invalid_orders_statuses_str),
    'TEXT_ORDER_FILTER_INTRO2'=>TEXT_ORDER_FILTER_INTRO2,
    'SELECTED_ORDERS_STATUS'=>(sizeOf($valid_orders_statuses))?current($valid_orders_statuses):0,
    'BUTTON_ORDERS_STATUS_FILTER'=>BUTTON_ORDERS_STATUS_FILTER,
    'TEXT_STATS_STATUS_FILTER'=>TEXT_STATS_STATUS_FILTER,
    'TEXT_SEARCH_FILTER'=>TEXT_SEARCH_FILTER
));    
echo $smarty->fetch('distributor_orders_proposal.html');
?>

	</td>
</tr>
</table>
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
