<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                             Author M. ASPELEITER <dazze@gmx.de>
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/
require_once(DIR_FS_INC.'yes_get_products_ordered_by_distributors.inc.php');
$do = new distributor_order($_GET['doID']);
$products_raw = $do->get_products_grouped();
$products_num = sizeOf($products_raw);
$products = array();
if($products_num > 0){
	if(isset($_REQUEST['order_by'])){
		$sort_asc = true;
		$order_by = $_REQUEST['order_by'];
		$parts = explode(' ',$_REQUEST['order_by']);
		if(sizeOf($parts)>1){
			list($order_by,$direction) = $parts;
			if(strtolower($direction) == 'desc')
				$sort_asc = false;
		}
		$smarty->assign('SUBMITTED_ORDER_BY',$order_by);
		$smarty->assign('SUBMITTED_ORDER_DIRECTION',(($sort_asc)?'asc':'desc'));
		$products_raw = $do->sort_array($products_raw, $order_by,$sort_asc);
	}
	foreach($products_raw as $product) {
		$ek_price_data = xtc_get_price_ek_data($product['id'],'MIN',$do->info['distributor_id']);
		
		if(isset($ek_price_data['vpe']))
			$product['VPE'] = $ek_price_data['vpe'];
		if(isset($ek_price_data['vse']))
			$product['VSE'] = $ek_price_data['vse'];
		
		$mind_query = xtc_db_query(sprintf(
			"SELECT mindestbestellmenge FROM products_distributors WHERE products_id='%s' AND distributor_id='%s'",
			$product['id'], $do->info['distributor_id']
		));
		if(xtc_db_num_rows($mind_query)){
			$mind = xtc_db_fetch_array($mind_query);
			$product['MINDESTBESTELLMENGE'] = (int)$mind['mindestbestellmenge'];
		}
		if($product['allow_tax'] == 1 and $product['tax'] > 0){
		    $product['price'] = number_format(xtc_oe_get_price_o_tax($product['price'], $product['tax'], false),3,'.','');
		    $product['final_price'] = number_format(xtc_oe_get_price_o_tax($product['final_price'], $product['tax'], false),3,'.','');
		}
		
		$product['distributor_number'] = yes_get_products_distributor_number($product['id'], $do->info['distributor_id']);
		$product['edit_form'] = xtc_draw_form('product_edit'.$product['dopID'], 'distributor_orders_edit.php', 'action=product_edit', 'post');
		$product['input_dID'] = xtc_draw_hidden_field('dID', $_GET['dID']);
		$product['input_doID'] = xtc_draw_hidden_field('doID', $_GET['doID']);
		$product['input_opID'] = xtc_draw_hidden_field('opID', $product['dopID']);
		$product['input_pID'] = xtc_draw_hidden_field('products_id', $product['id']);
		$product['pID'] = $product['id'];
		$product['input_quantity'] = xtc_draw_input_field('products_quantity', $product['qty'], 'size="2" maxlength="6"');
		$product['input_name'] = xtc_draw_input_field('products_name', $product['name'], 'size="40"');
		$product['input_model'] = xtc_draw_input_field('products_model', $product['model'], 'size="20"');
		$product['input_tax'] = xtc_draw_hidden_field('products_tax', $product['tax']).number_format($product['tax'],2,',','.').'%';
		$product['tax_rate'] = $product['tax'];
		$product['input_price'] = xtc_draw_input_field('products_price', $product['price'], 'size="10"');
		$product['final_price'] = $product['final_price'];
		$product['delete_link'] =  xtc_href_link('distributor_orders_edit.php', 'action=product_delete&opID='.$product['dopID'].'&pID='.$product['id'].'&doID='.$_GET['doID']);
		$products[] = $product;
	} // end foreach
}// end if has products
$only_allocateds_checked = 1;
if($_REQUEST['search'] != '' and !isset($_REQUEST['only_allocateds'])){
    $only_allocateds_checked = 0;
}
$smarty->assign(array(
	'products'=>$products,
    'LINK_NO_SEARCH'=>xtc_href_link('distributor_orders_edit.php',xtc_get_all_get_params(array('action','search','searchmode'))),
    'ALLOW_TAX'=>$do->info['allow_tax'],
	'JS_CONFIRM_REALLY_DELETE_DOP'=>JS_CONFIRM_REALLY_DELETE_DOP,
	'SORT_BASE_URL'=>xtc_href_link('distributor_orders_edit.php',xtc_get_all_get_params(array('order_by'))),
    'TEXT_USE_LB_PRODUCT_PRICE_AS_EK_PRICE'=>TEXT_USE_LB_PRODUCT_PRICE_AS_EK_PRICE,
    'TEXT_USE_LB_PRODUCT_PRICE_AS_DEFAULT_EK_PRICE'=>TEXT_USE_LB_PRODUCT_PRICE_AS_DEFAULT_EK_PRICE,
    'TEXT_USE_LB_PRODUCT_PRICE_AS_EK_PRICE_SHORT'=>TEXT_USE_LB_PRODUCT_PRICE_AS_EK_PRICE_SHORT,
    'TEXT_USE_LB_PRODUCT_PRICE_AS_DEFAULT_EK_PRICE_SHORT'=>TEXT_USE_LB_PRODUCT_PRICE_AS_DEFAULT_EK_PRICE_SHORT,
    'JS_PROMPT_BRUTTO_PRICE'=>JS_PROMPT_BRUTTO_PRICE,
    'JS_PROMPT_NETTO_PRICE'=>JS_PROMPT_NETTO_PRICE,
    'TEXT_BRUTTO_CALC'=>TEXT_BRUTTO_CALC,
    'TEXT_NETTO_CALC'=>TEXT_NETTO_CALC,
    'DISTRIBUTOR_NAME'=>  xtc_get_distributor_name((int)xtc_db_input($_REQUEST['dID'])),
    'DISTRIBUTOR_ID'=>(int)xtc_db_input($_REQUEST['dID']),
    'TEXT_PROMPT_NEW_DISTRIBUTOR_NUMBER'=>TEXT_PROMPT_NEW_DISTRIBUTOR_NUMBER,
    'TEXT_ONLY_ALLOCATEDS'=>TEXT_ONLY_ALLOCATEDS,
    'ONLY_ALLOCATEDS'=>$only_allocateds_checked,
    'DISTRIBUTOR_ORDER_PRODUCTS_DISTRIBUTOR_PRICES_AUTOMATIC_INSERT'=>DISTRIBUTOR_ORDER_PRODUCTS_DISTRIBUTOR_PRICES_AUTOMATIC_INSERT,
    'TEXT_SELECT_PRODUCTS_SEARCH_DEFAULT'=>TEXT_SELECT_PRODUCTS_SEARCH_DEFAULT,
    'BUTTON_SELECT_PRODUCTS_SEARCH_DEFAULT'=>BUTTON_SELECT_PRODUCTS_SEARCH_DEFAULT,
));

$smarty->assign('search_form',xtc_draw_form('product_search', 'distributor_orders_edit.php', '', 'get'));
$smarty->assign('search_form_edit_action',xtc_draw_hidden_field('edit_action', 'products'));
$smarty->assign('search_form_action',xtc_draw_hidden_field('action', 'product_search'));
$smarty->assign('search_form_doID',xtc_draw_hidden_field('doID', $_GET['doID']));
$smarty->assign('search_form_dID',xtc_draw_hidden_field('dID', $_REQUEST['dID']));
$search = (isset($_GET['search']))? $_GET['search'] : '';
$smarty->assign('search_form_input',xtc_draw_input_field('search', $search, 'size="30"'));

$searchmode_default_query = xtc_db_query(sprintf(
        "SELECT distributor_orders_edit_products_search_default FROM %s WHERE customers_id='%d'",
        TABLE_CUSTOMERS,$_SESSION['customer_id']
));
$searchmode_default = xtc_db_fetch_array($searchmode_default_query);
function get_searchmode_status($mode){
    global $searchmode_default;
    if(isset($_GET['searchmode'])){
        if($_GET['searchmode'] == $mode){
            return true;
        }
    }else{
        if($searchmode_default['distributor_orders_edit_products_search_default'] == $mode){
            return true;
        }
        if($searchmode_default['distributor_orders_edit_products_search_default']=='' and $mode == 'pid'){
            return true;
        }
    }
    return false;
}
$smarty->assign('search_form_mode_pname_status',get_searchmode_status('pname'));
$smarty->assign('search_form_mode_pid_status',get_searchmode_status('pid'));
$smarty->assign('search_form_mode_ean_status',get_searchmode_status('ean'));
$smarty->assign('search_form_mode_model_status',get_searchmode_status('model'));
$smarty->assign('search_form_mode_distributor_product_number_status',get_searchmode_status('distributor_product_number'));

if(isset($_GET['action']) and $_GET['action'] =='product_search') {
	$smarty->assign('search_mode',1);
	$search = xtc_db_input($_GET['search']);
	$from_sql = sprintf(" %s p, %s pd",TABLE_PRODUCTS,TABLE_PRODUCTS_DESCRIPTION);
	$where_sql = sprintf(" p.products_id = pd.products_id and pd.language_id = '%s' ",$_SESSION['languages_id']);
	
	if($_GET['searchmode'] == 'distributor_product_number'){
	    $query_raw = sprintf("select
		     p.products_id,
		     p.products_model,
		     pd.products_name,
		     p.products_image,
		     p.products_status,
		     dp.distributor_products_number,
		     dp.mindestbestellmenge
		     from %s, products_distributors dp
		     where %s		     
		     and dp.distributor_id='%s' and dp.products_id=p.products_id ",
		    $from_sql,$where_sql,
		    xtc_db_input($_GET['dID'])
	    );
	}else{
	    if(isset($_REQUEST['only_allocateds']) and $_REQUEST['only_allocateds'] == 1){
		$from_sql .= ", products_distributors dp";
		$where_sql .= sprintf(" and dp.distributor_id='%s' and dp.products_id=p.products_id ",xtc_db_input($_GET['dID']));
	    }
	    $query_raw = sprintf("select
		     p.products_id,
		     p.products_model,
		     pd.products_name,
		     p.products_image,
		     p.products_status
		     from %s
		     where %s",
		    $from_sql,
		    $where_sql
	    );
	}
	if($_GET['searchmode'] == 'pname'){
		$query_raw .= sprintf( " and pd.products_name like '%%%s%%' order by pd.products_name",$search);
	}else if($_GET['searchmode'] == 'ean'){
		$query_raw .= sprintf(" and p.products_ean like '%%%s%%' order by pd.products_name",$search);
	}else if($_GET['searchmode'] == 'model'){
		$query_raw .= sprintf(" and p.products_model like '%%%s%%' order by pd.products_name",$search);
	}else if($_GET['searchmode'] == 'distributor_product_number'){
	    $query_raw .= sprintf(" and dp.distributor_products_number like '%%%s%%' order by pd.products_name",$search);
	}else{ // pid
	    $query_raw .= sprintf(" and p.products_id='%s' order by pd.products_name",$search);
	}
	$products_query = xtc_db_query($query_raw);
	$products_result = array();
	$search_results = array();
	while($products = xtc_db_fetch_array($products_query)) {
	    $products_result[] = $products;
	}
	foreach($products_result as $products){
		$search_result = array();
		if(!isset($product['mindestbestellmenge'])){
		    $query = xtc_db_query(sprintf(
			    "SELECT mindestbestellmenge FROM products_distributors WHERE products_id='%s' AND distributor_id='%s'",
			    $products['products_id'],(int)xtc_db_input($_REQUEST['dID'])
		    ));
		    if(xtc_db_num_rows($query)){
			$record = xtc_db_fetch_array($query);
			$search_result['mindestbestellmenge'] = (int)$record['mindestbestellmenge'];
		    }else{
			$search_result['dist_unallocated'] = 1;
			$search_result['mindestbestellmenge'] = 0;
		    }
		    $unallocated_ek_price_data = xtc_get_price_ek_data($products['products_id']);
		    $search_result['unallocated_price'] = number_format($unallocated_ek_price_data['price'],4,',','');
		    $search_result['unallocated_price_distributor_name'] = xtc_get_distributor_name($unallocated_ek_price_data['distributor_id']);
		}
		$properties = array();
		$properties_id_array = yes_get_products_properties_id_array($products['products_id']);
		foreach($properties_id_array as $properties_id){
			$property = new product_properties($properties_id);
			$property_description = $property->getDescription($_SESSION['languages_id']);
			$property_values_array = array();
			$property_values = $property->getValues($_SESSION['languages_id']);
			foreach($property_values as $pv){
				$property_values_array[] = array(
					'id'=>$pv['description']->getProducts_properties_values_id(),
					'title'=>$pv['description']->getTitle()
				);
			}
			if(sizeOf($property_values_array)){
				$properties[] = array(
					'properties_id'=>$properties_id,
					'title'=>$property_description->getTitle(),
					'values'=>$property_values_array
				);
			}
		}
		if(sizeOf($properties)){
			$search_result['PROPERTIES'] = $properties;
		}
		
		$collies = xtc_get_product_collies($products['products_id']);
		$ek_price_data = xtc_get_price_ek_data($products['products_id'],'MIN',$_GET['dID']);
		$ek = $ek_price_data['price'];
		if(isset($ek_price_data['vpe']))
			$search_result['VPE'] = $ek_price_data['vpe'];
		if(isset($ek_price_data['vse']))
			$search_result['VSE'] = $ek_price_data['vse'];
		$search_result['MINDESTBESTELLMENGE'] = (int)$products['mindestbestellmenge'];
		if(sizeOf($collies)>0){
			$search_result['collies_rowspan'] = (sizeOf($collies)+1);
			$collies_array = array();
			foreach($collies as $k=>$collie){
				// auch LieferantenNr anzeigen
				$dist_products_name_query_raw = sprintf("SELECT distributor_products_number FROM products_distributors WHERE products_id='%s' AND distributor_id='%s'",$collie['collie_products_id'],xtc_db_input($_GET['dID']));
				$dist_products_name_query = xtc_db_query( $dist_products_name_query_raw);
				$dist_products_name_res = xtc_db_fetch_array($dist_products_name_query);
				$distributor_number = $dist_products_name_res['distributor_products_number'];
				$collies_array[] = array('qty'=>$collie['quantity'],
					'name'=>xtc_get_products_name($collie['collie_products_id']),
					'distributor_number'=>$distributor_number);
			}
			$search_result['collies'] = $collies_array;
		}
		$search_result['pID'] = $products['products_id'];
		$search_result['input_quantity'] = xtc_draw_input_field('products_quantity['.$products['products_id'].']', '0', 'size="3"');
		$search_result['distributor_number'] = $products['distributor_products_number'];
		
		$query = xtc_db_query(sprintf(
			"SELECT pdi.* FROM products_distributors pdi WHERE products_id='%s' ORDER BY is_default DESC LIMIT 1",
			$products['products_id']
		));
		if(xtc_db_num_rows($query)){
		    $search_result['default_distributor'] = xtc_db_fetch_array($query);
		    $query = xtc_db_query(sprintf(
			    "SELECT * FROM distributor_product_prices dpp WHERE products_id='%s' AND distributor_id='%s' ORDER BY is_default DESC,date_saved DESC LIMIT 1",
			    $products['products_id'],$search_result['default_distributor']['distributor_id']
		    ));
		    if(xtc_db_num_rows($query)){
			$record = xtc_db_fetch_array($query);
			$record['distributor_name'] = xtc_get_distributor_name($record['distributor_id']);
			$search_result['default_ek'] = $record;
		    }
		}
		$search_result['products_name'] = $products['products_name'];
		$search_result['products_model'] = $products['products_model'];
		$search_result['ek'] = number_format($ek,2,',','.').'&nbsp;'.DEFAULT_CURRENCY;
		$SQ = new products_quantity($products['products_id']);
		
		$search_result['distributor_ordered'] = yes_get_products_ordered_by_distributors($products['products_id']);;
		$search_result['shop_orders'] = $SQ->get_not_shipped_qty();
		$search_result['qty_phys'] = $SQ->get_products_total_qty();
		$_col = xtc_get_product_in_collies($products['products_id']);
		$search_result['sells_4weeks'] = yes_get_products_sells($products['products_id'], 28, $_col, array(ORDERS_STATUS_STORNIERT) );
		$search_result['sells_3month'] = yes_get_products_sells($products['products_id'], 28*3, $_col, array(ORDERS_STATUS_STORNIERT) );
		$search_result['sells_6month'] = yes_get_products_sells($products['products_id'], 28*6, $_col, array(ORDERS_STATUS_STORNIERT) );
		$search_result['sells_12month'] = yes_get_products_sells($products['products_id'], 365, $_col, array(ORDERS_STATUS_STORNIERT) );
		$search_result['newest_ek_data'] = xtc_get_price_ek_data($products['products_id'], 'NEWEST', (int)xtc_db_input($_GET['dID']));
		
		$search_results[] = $search_result;
	}
	$smarty->assign('SEARCH_FORM',xtc_draw_form('product_ins',
	    'distributor_orders_edit.php',
	    'action=product_ins&dID='.
		((isset($_POST['dID']) and $_POST['dID']!='')?$_POST['dID']:$_GET['dID']).
		'&doID='.$_GET['doID'], 
	    'post'
	));
	$smarty->assign(array(
            'search_results'=>$search_results,
        ));
}
$html = $smarty->fetch('distributor_orders_edit_products.html');
echo $html;
