<?php
include('includes/cron_application_top.php');
$_SESSION['language'] = 'german';
require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.php');
include(DIR_WS_CLASSES.'order.php');
require_once(DIR_FS_CATALOG.DIR_WS_CLASSES.'class.phpmailer.php');
require_once(DIR_FS_INC . 'xtc_php_mail.inc.php');
$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$smarty->assign('STORE_NAME_ADDRESS',STORE_NAME_ADDRESS);
if(!defined('SEND_FEEDBACK_MAIL_DURATION_WEEKS') or SEND_FEEDBACK_MAIL_DURATION_WEEKS == 0){
	die('Kein SEND_FEEDBACK_MAIL_DURATION_WEEKS Wert &uuml;ber Null.');
}
$counter = 0;
$query = xtc_db_query(sprintf(
	"SELECT orders_id FROM shippings WHERE feedback_mail_sent=0 AND orders_id > 0 AND status=1 AND date_finished>%s LIMIT 200",
	date('Y-m-d', (time() - (60*60*24*7*SEND_FEEDBACK_MAIL_DURATION_WEEKS)) )
));
while($row = xtc_db_fetch_array($query)){
	$counter++;
	$order = new order($row['orders_id']);
	$products_string_html = '';
	$products_string_text = '';
	foreach($order->products as $product){
		$products_string_html .= sprintf(
			"%s x <i>%s</i> - %s<br />",$product['qty'],$product['model'],$product['name']
		);
		$products_string_text .= sprintf(
			"%s x %s - %s\r\n",$product['qty'],$product['model'],$product['name']
		);
	}
	$ebay_str = '';
	$ebay_id_array = $order->get_auction_array();
	if(sizeOf($ebay_id_array)){
		foreach($ebay_id_array as $ebay_array){
			$ebay_str .= $ebay_array['ebay_id'].', ';
		}
		$ebay_str = substr($ebay_str,0,strlen($ebay_str)-2);
	}
	$smarty->assign(array(
		'PRODUCTS_HTML'=>$products_string_html,
		'PRODUCTS_TEXT'=>$products_string_text,
		'NAME'=>$order->customer['name'],
		'EBAYID'=>$ebay_str
	));
	$html_mail = $smarty->fetch('send_feedback.html');
	$text_mail = $smarty->fetch('send_feedback.txt');
	$subject = sprintf(SUBJECT_SEND_FEEDBACK_MAIL,$order->info['id']);
	// send mail to customer
	xtc_php_mail(EMAIL_BILLING_ADDRESS,
		EMAIL_BILLING_NAME,
		$order->customer['email_address'],
		$order->customer['name'],
		'',
		EMAIL_BILLING_REPLY_ADDRESS,
		EMAIL_BILLING_REPLY_ADDRESS_NAME,
		'',
		'',
		$subject,
		$html_mail,
		$text_mail
	);
	$notified = 1;
	\YES4Trade\Model\ebay_emails::create_ebay_emails([
		'subject'=>$subject,
		'mailto'=>$order->customer['email_address'],
		'from_name'=>EMAIL_BILLING_NAME,
		'from_email'=>EMAIL_BILLING_ADDRESS,
		'date'=>date('Y-m-d H:i:s'),
		'customers_id'=>intval($order->customer['ID']),
		'orders_id'=>intval($order->info['id']),
		'allocation_status'=>\YES4Trade\Model\ebay_emails::ALLOCATION_STATUS1,
		'ownmail'=>\YES4Trade\Model\ebay_emails::OWNMAIL1,
		'format'=>'text/html'
	],$html_mail);
	$update_sql_array = array(
		'feedback_mail_sent'=>1
	);
	yes_db_perform('shippings',$update_sql_array,'update',[
		'orders_id'=>intval($row['orders_id'])
	]);
	$order->add_history($order->info['orders_status'], 1, ORDER_HISTORY_MAIL_SENT);
}
die('Es wurden '.$counter.' Auftr&auml;ge gemailt.');