<?php
include('includes/application_top.php');
require_once(DIR_FS_INC.'yes_multisort.inc.php');
require_once(DIR_FS_CATALOG.'includes/classes/xtcPrice.php');
$default_from = date('Y-m-d',(time()-(60*60*24)));
$sort_by = $_REQUEST['sort_by'] ?? 'orders_id';
$from = $_REQUEST['start_date'] ?? $default_from;
$to = $_REQUEST['end_date'] ?? date('Y-m-d');
$coupon_code = $_GET['coupon_code'] ?? '';
$orders_statuses_array = xtc_get_orders_status();
$orders_statuses = $_REQUEST['orders_status'] ?? array();
if(sizeOf($orders_statuses)){
    foreach($orders_statuses as $k=>$os){
	$exists = false;
	foreach($orders_statuses_array as $osa){
	    if($os == $osa['id']){
		$exists = true;
	    }
	}
	if(!$exists){
	    unset($orders_statuses[$k]);
	}
    }
}

$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$items = array();
if(!empty($coupon_code)){
	$parameters = [
		'code'=>$coupon_code
	];
	$query_raw = sprintf(
		"SELECT crt.order_id,crt.redeem_date,c.coupon_code,c.coupon_id,o.orders_status,ot.value FROM coupon_redeem_track crt LEFT JOIN coupons c USING(coupon_id),%s o LEFT JOIN %s ot USING(orders_id) WHERE o.orders_id=crt.order_id AND ot.class='ot_coupon' AND c.coupon_code=:code",
		TABLE_ORDERS,TABLE_ORDERS_TOTAL
	);
}else{
	$parameters = [
		'from'=>$from,
		'to'=>$to.' 23:59:59'
	];
	$query_raw = sprintf(
		"SELECT crt.order_id,crt.redeem_date,c.coupon_code,c.coupon_id,o.orders_status,ot.value FROM coupon_redeem_track crt LEFT JOIN coupons c USING(coupon_id),%s o LEFT JOIN %s ot USING(orders_id) WHERE o.orders_id=crt.order_id AND ot.class='ot_coupon' AND crt.redeem_date > :from AND crt.redeem_date < :to",
		TABLE_ORDERS,TABLE_ORDERS_TOTAL
	);
}
$coupon_total = [
	'uses'=>0,
	'sum'=>0
];

$query = yes_query($query_raw,$parameters);
foreach($query as $record){
    $items[] = array(
		'COUPON_ID'=>$record['coupon_id'],
		'ORDERS_ID'=>$record['order_id'],
		'REDEEM_DATE'=>xtc_date_short($record['redeem_date']),
		'COUPON_CODE'=>$record['coupon_code'],
		'COUPON_VALUE'=>$record['value'],
		'ORDERS_STATUS'=>  xtc_get_orders_status_name($record['orders_status']),
    );
	if(!empty($coupon_code)){
		$coupon_total['uses']++;
		$coupon_total['sum'] += floatval($record['value']);
	}
}
if(sizeOf($items)){
    $sort_dir = (isset($_REQUEST['sort_dir']) and $_REQUEST['sort_dir'] == 'DESC') ? SORT_DESC : SORT_ASC;
    $items = yes_multisort($items,$sort_by,$sort_dir);
}
if(isset($_REQUEST['csv'])){
	require(DIR_WS_CLASSES.'class.csv.php');
	$filename = sprintf('coupon_orders_'.date('Y-m-d_His').'.csv');
	$fh = fopen(\main::get_exportdata_path().$filename,'a+') or die("Kann ".$filename." nicht anlegen.");
	fclose($fh);
	$CSV = new CSVfile(\main::get_exportdata_path().$filename);
	$CSV->delimiter = "\t";
	$CSV->open('w');
	$csv_header = array(
            'ID',
	    TABLE_HEADING_ORDERS_ID,
	    TABLE_HEADING_REDEEM_DATE,
	    TABLE_HEADING_COUPON_CODE,
	    TABLE_HEADING_COUPON_VALUE,
	    TABLE_HEADING_ORDERS_STATUS
	);
	$CSV->addRow($csv_header);
	foreach($items as $product){
	    $line = array();
	    foreach($product as $pdn=>$pd){
			$line[] = "$pd";
	    }
	    $CSV->addRow($line);
	}
	$CSV->close();
	$content = file_get_contents(\main::get_exportdata_path().$filename);
	unlink(\main::get_exportdata_path().$filename);
	$len = strlen($content);
	header("Content-type: text/csv");
	header("Content-Disposition: attachment; filename=".$filename);
	header("Content-Length: ".$len);
	echo $content;
	exit;
}
yes_draw_pre_header();
yes_draw_header(TITLE);

$buttons = array();
$sort_dir = $_REQUEST['sort_dir']??null;
$smarty->assign(array(
    'PAGE_HEADING'=>PAGE_HEADING,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
    'from'=>$from,
    'to'=>$to,
	'ADDITIONAL_TITLE'=>$ADDITIONAL_TITLE,
    'ORDERS_STATUSES_REQUEST'=>$orders_statuses,
    'ORDERS_STATUSES_ARRAY'=>$orders_statuses_array,
    'TEXT_ONLY_ORDERS_STATUS'=>TEXT_ONLY_ORDERS_STATUS,
    'TEXT_STARTDATE'=>TEXT_STARTDATE,
    'TEXT_ENDDATE'=>TEXT_ENDDATE,
    'TABLE_HEADING_ORDERS_ID'=>TABLE_HEADING_ORDERS_ID,
    'TABLE_HEADING_REDEEM_DATE'=>TABLE_HEADING_REDEEM_DATE,
    'TABLE_HEADING_COUPON_CODE'=>TABLE_HEADING_COUPON_CODE,
    'TABLE_HEADING_COUPON_VALUE'=>TABLE_HEADING_COUPON_VALUE,
    'TABLE_HEADING_ORDERS_STATUS'=>TABLE_HEADING_ORDERS_STATUS,
    'items'=>$items,
    'SORTING'=>$sort_by,
    'SORT_DIR'=>($sort_dir == 'DESC') ? 'DESC' : 'ASC',
    'BASELINK_SORT'=>xtc_href_link(basename(__FILE__), xtc_get_all_get_params(array('sort_by','sort_dir'))),
    'TEXT_STATS_STATUS_FILTER'=>TEXT_STATS_STATUS_FILTER,
	'INPUT_COUPON_CODE'=>xtc_draw_input_field('coupon_code',$coupon_code,'id="search_coupon_code"'),
	'COUPON_CODE'=>$coupon_code,
));
if(!empty($coupon_code)){
	$xtcPrice = new \xtcPrice(DEFAULT_CURRENCY,DEFAULT_CUSTOMERS_STATUS_ID);
	$smarty->assign('COUPON_STATS',sprintf('<b>%d</b> %s, Total: <b>%s</b>',
		$coupon_total['uses'], TEXT_USES, $xtcPrice->xtcFormat($coupon_total['sum'],true)
	));
}


$smarty->display('coupon_orders.html');
include('includes/footer.php');
include('includes/application_bottom.php');
