<?php
// shop/admin/connector.php
use elFinder;
use elFinderConnector;
use elFinderVolumeLocalFileSystem;

$opts = [
    'roots' => [
        [
            'driver'        => 'LocalFileSystem',
            'path'          => DIR_FS_CATALOG.'files/',
            'URL'           => HTTPS_CATALOG_SERVER.'/files/',
            'uploadDeny'    => [
                'application/x-php',
                'text/x-php',
                'application/x-sh',
                'application/x-cgi',
                'application/x-perl',
                'application/x-python',
                'text/x-shellscript',
                'text/x-python',
                'text/x-perl',
                'application/x-msdownload'
            ],
            'uploadAllow'   => ['text/csv','application/zip','application/x-zip-compressed','image', 'application/pdf', 'text/plain'], // oder ['all'] wenn du mehr freigeben willst
            'uploadOrder'   => ['deny', 'allow'], // Wichtig: ZUERST verbieten
            'accessControl' => function ($attr, $path) {
                // Dotfiles verstecken
                return strpos(basename($path), '.') === 0
                    ? !($attr === 'read' || $attr === 'write')
                    : null;
            },
            'attributes' => [
                [
                    'pattern' => '/\.(php|php[3457]?|phtml|pl|py|sh|cgi|exe|bat|cmd)$/i',
                    'read'    => false,
                    'write'   => false,
                    'hidden'  => true,
                    'locked'  => true,
                ]
            ]
        ]
    ]
];

$connector = new elFinderConnector(new elFinder($opts));
$connector->run();
