<?php
namespace AmazonPay;
include('includes/application_top.php');
if(!defined('MODULE_PAYMENT_YES_AMAZON_PAY_STATUS') or MODULE_PAYMENT_YES_AMAZON_PAY_STATUS != 'True'){
	die('Invalid call');
}
require_once(DIR_FS_CATALOG.'lang'.DIRECTORY_SEPARATOR.$_SESSION['language'].DIRECTORY_SEPARATOR.'modules'.DIRECTORY_SEPARATOR.'payment'.DIRECTORY_SEPARATOR.'yes_amazon_pay.php');
$config = array(
    'merchant_id'=>MODULE_PAYMENT_YES_AMAZON_PAY_MERCHANT_ID,
    'access_key'  => MODULE_PAYMENT_YES_AMAZON_PAY_ACCESS_KEY,
    'secret_key'  => MODULE_PAYMENT_YES_AMAZON_PAY_SECRET_KEY,
    'client_id'   => MODULE_PAYMENT_YES_AMAZON_PAY_CLIENT_ID,
    'region'      => MODULE_PAYMENT_YES_AMAZON_PAY_REGION,
    'sandbox'     => (MODULE_PAYMENT_YES_AMAZON_PAY_SANDBOX == 'True') ? true : false
);
require_once DIR_FS_CATALOG.'AmazonPay/Client.php';
require_once DIR_WS_CLASSES.'order.php';
include(DIR_FS_CATALOG.'includes/modules/payment/yes_amazon_pay.php');
function parseErrorMsg($xml_string){
	$error_xml = new \SimpleXMLElement($xml_string);
	return sprintf('%s: %s',
		$error_xml->Error->Code,
		$error_xml->Error->Message
	);
}
$action = (isset($_GET['action'])) ? $_GET['action'] : '';
/*if(isset($_SESSION['customer_id']) and $_SESSION['customer_id'] > 0){
	xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_SHIPPING));
}
if(!isset($_SESSION['yes_amazon_pay_access_token']) or empty($_SESSION['yes_amazon_pay_access_token'])){
	xtc_redirect(xtc_href_link(FILENAME_SHOPPING_CART));
}
*/
switch($action){
	case 'refund':
		$com = xtc_db_prepare_input(urldecode($_GET['refund_comment']));
		if(!stristr(CHARSET,'utf-8')){
			$com = utf8_decode($com);
		}
		if(strlen($com) < 3){
			$messageStack->add_session('[Amazon Payment Refund] '.JS_ALERT_NO_COMMENT,'error');
			xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action','yes_amazon_pay_reference_id','refund_amount','refund_comment')).'action=edit'));
		}
		$amount = str_replace(',','.',$_GET['refund_amount']);
		if((float)$amount < 0.01){
			$messageStack->add_session('[Amazon Payment Refund] '.JS_ALERT_INVALID_REFUND_AMOUNT,'error');
			xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action','yes_amazon_pay_reference_id','refund_amount','refund_comment')).'action=edit'));
		}
		if(!isset($_GET['oID']) or $_GET['oID'] < 1){
			$messageStack->add_session('[Amazon Payment Refund] '.MSG_ERROR_MISSING_ORDERS_ID,'error');
			xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action','yes_amazon_pay_reference_id','refund_amount','refund_comment')).'action=edit'));
		}
		$amazon_capture_id = xtc_db_input($_GET['amazon_capture_id']);
		$RRid = 'Ref_'.(int)xtc_db_input($_GET['oID']).'_'.date('Ymdhis');
		$reason = xtc_db_input($_GET['reason']);
		$client = new Client($config);
		$requestParameters = array(
			'amazon_capture_id' => $amazon_capture_id,
			'refund_reference_id'=>$RRid,
			'refund_amount'=>$amount,
			'currency_code'=>DEFAULT_CURRENCY,
			'seller_refund_note'=>'Refund order #'.(int)xtc_db_input($_GET['oID']),
		);
		$response = $client->refund($requestParameters);
		$amz_error = \yes_amazon_pay::checkAmazonResponseXML($response);
		if($amz_error != ''){
			if(!stristr(CHARSET,'utf-8')){
				$amz_error = utf8_encode($amz_error);
			}
			$messageStack->add_session('[Amazon Payment Refund] '.$amz_error,'error');
			xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action','yes_amazon_pay_reference_id','refund_amount','refund_comment')).'action=edit'));
		}
		$sxe = new \SimpleXMLElement($response->response['ResponseBody']);
		$RD = $sxe->RefundResult->RefundDetails;
		$order = new \order((int)xtc_db_input($_GET['oID']));
		$insert_sql_array = array(
			'AmazonRefundId'=>$RD->AmazonRefundId,
			'RefundReferenceId'=>$RD->RefundReferenceId,
			'RefundType'=>$RD->RefundType,
			'SellerRefundNote'=>(isset($RD->SellerRefundNote)) ? $RD->SellerRefundNote : '',
			'Currency'=>$RD->RefundAmount->CurrencyCode,
			'RefundedAmount'=>$RD->RefundAmount->Amount,
			'FeeRefunded'=>$RD->FeeRefunded->Amount,
			'RefundStatus'=>$RD->RefundStatus->State,
			'date_created'=>$RD->CreationTimestamp,
			'yes_amazon_pay_reference_id'=>$order->info['yes_amazon_pay_reference_id']
		);
		xtc_db_perform('yes_amazon_pay_refunds',$insert_sql_array);
		$comments = sprintf(TEXT_ORDERS_STATUS_COMMENT_REFUND,$RD->RefundAmount->Amount,$com);
		$order->add_history($order->info['orders_status'],false,$comments);
		$messageStack->add_session($comments,'success');
		xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action','yes_amazon_pay_reference_id','refund_amount','refund_comment')).'action=edit'));
		break;
	case 'closeOrder':
		$error = array();
		if(!isset($_GET['amazon_order_reference_id']) or empty($_GET['amazon_order_reference_id'])){
			die(json_encode(array(
				'ERROR'=>'Missing Reference'
			)));
		}
		if(!isset($_GET['reason']) or empty($_GET['reason'])){
			die(json_encode(array(
				'ERROR'=>'Add a reason for closing this order'
			)));
		}
		$amazon_order_reference_id = xtc_db_input($_GET['amazon_order_reference_id']);
		$reason = xtc_db_input($_GET['reason']);
		$client = new Client($config);
		$requestParameters = array(
			'amazon_order_reference_id' => $amazon_order_reference_id,
			'cancelation_reason'=>$reason
		);
		$response = $client->cancelOrderReference($requestParameters);
		$amz_error = \yes_amazon_pay::checkAmazonResponseXML($response);
		if($amz_error == ''){
			die(json_encode(array(
				'ERROR'=>''
			)));
		}else{
			if(!stristr(CHARSET,'utf-8')){
				$amz_error = utf8_encode($amz_error);
			}
			die(json_encode(array(
				'ERROR'=>$amz_error
			)));
		}
		break;
}
if(!isset($_GET['yes_amazon_pay_reference_id']) or empty($_GET['yes_amazon_pay_reference_id'])){
	$smarty = new \yesSmarty;
	$smarty->assign(array(
		'TEXT_INPUT_AMAZON_REFERENCE_ID'=>TEXT_INPUT_AMAZON_REFERENCE_ID,
		'INPUT_AMAZON_REFERENCE_ID'=>xtc_draw_input_field('AmazonOrderReferenceId','','size="32" maxlength="32" class="aorID"'),
		'ACTION'=>'amazon_reference_search',
		'SEARCH'=>IMAGE_SEARCH,
	));
}else{
	$yaprID = xtc_db_input($_GET['yes_amazon_pay_reference_id']);
	$client = new Client($config);
	$requestParameters = array(
		'amazon_order_reference_id' => $yaprID,
	);
	$response = $client->getOrderReferenceDetails($requestParameters);
	$amz_error = \yes_amazon_pay::checkAmazonResponseXML($response);
	if($amz_error != ''){
		if(!stristr(CHARSET,'utf-8')){
			$amz_error = utf8_encode($amz_error);
		}
		printf('<p class="error">%s</p>',$amz_error);
		exit;
	}
	$sxe = new \SimpleXMLElement($response->response['ResponseBody']);
	$ORD = $sxe->GetOrderReferenceDetailsResult->OrderReferenceDetails;
	$smarty = new \yesSmarty;
	// WIR BRAUCHEN DIE CAPTURE_ID (AuthorizationID)
	$query = xtc_db_query(sprintf(
		"SELECT IdList_member FROM yes_amazon_pay_authorization WHERE OrderReferenceID='%s'",
		$ORD->AmazonOrderReferenceId
	));
	if(xtc_db_num_rows($query)){
		$record = xtc_db_fetch_array($query);
		$reli = xtc_href_link('amazon_payments.php',
			xtc_get_all_get_params(array('action','refund_amount','refund_comment','amazon_capture_id'))
			.'action=refund&amazon_capture_id='.$record['IdList_member']
		);
		$smarty->assign('REFUND_LINK',$reli);
	}

	$amazon_payment_refunds = array();
	$query = xtc_db_query(sprintf(
		"SELECT SUM(RefundedAmount) as TOTAL_REFUNDED FROM yes_amazon_pay_refunds WHERE yes_amazon_pay_reference_id='%s'",
		$yaprID
	));
	$record = xtc_db_fetch_array($query);
	$smarty->assign(array(
		'TOTAL_REFUNDED'=>$record['TOTAL_REFUNDED'],
		'TOTAL_REFUNDED_FORMATTED'=>number_format($record['TOTAL_REFUNDED'],2,',','.').' '.DEFAULT_CURRENCY,
		'YES_AMZ_PAY_CLIENT_ID'=>$config['client_id'],
		'YES_AMZ_PAY_MERCHANT_ID'=>$config['merchant_id'],
		'YAPRID'=>$yaprID,
		'OrderReferenceStatus'=>$ORD->OrderReferenceStatus->State,
		'OrderReferenceStatusLastUpdate'=>xtc_date_long($ORD->OrderReferenceStatus->LastUpdateTimestamp),
		'TEXT_LAST_STATUS_CHANGE'=>TEXT_LAST_STATUS_CHANGE,
		'TEXT_STATUS'=>TEXT_STATUS,
		'ExpirationTimestamp'=>xtc_date_long($ORD->ExpirationTimestamp),
		'TEXT_PAYMENT_EXPIRED'=>TEXT_PAYMENT_EXPIRED,
		'TEXT_STORE_INFO'=>TEXT_STORE_INFO,
		'STORE_NAME'=>$ORD->SellerOrderAttributes->StoreName,
		'STORE_TMP_ORDERS_ID'=>$ORD->SellerOrderAttributes->SellerOrderId,
		'TOTAL'=>$ORD->OrderTotal->Amount. ' ' .$ORD->OrderTotal->CurrencyCode,
		'TEXT_TOTAL'=>TEXT_TOTAL,
		'TEXT_BUYER'=>TEXT_BUYER,
		'BUYER_NAME'=>$ORD->Buyer->Name,
		'BUYER_EMAIL'=>$ORD->Buyer->Email,
		'TEXT_SELLERNOTE'=>TEXT_SELLERNOTE,
		'SELLERNOTE'=>$ORD->SellerNote,
		'TEXT_DATE_CREATED'=>TEXT_DATE_CREATED,
		'DATE_CREATED'=>xtc_date_long($ORD->CreationTimestamp),
		'TEXT_BILLING_ADDRESS'=>TEXT_BILLING_ADDRESS,
		'BILLING_ADDRESS'=>$ORD->BillingAddress->PhysicalAddress,
		'TEXT_REFUND'=>TEXT_REFUND,
		'JS_CONFIRM_REALLY_REFUND'=>JS_CONFIRM_REALLY_REFUND,
		'TEXT_REFUND_COMMENT'=>TEXT_REFUND_COMMENT,
		'TEXT_REFUND_AMOUNT'=>TEXT_REFUND_AMOUNT,
		'JS_ALERT_INVALID_REFUND_AMOUNT'=>JS_ALERT_INVALID_REFUND_AMOUNT,
		'JS_ALERT_NO_COMMENT'=>JS_ALERT_NO_COMMENT,
		'TEXT_EXISTING_REFUNDS'=>TEXT_EXISTING_REFUNDS,
	));
} // end if show details
echo $smarty->fetch('yes_amazon_payments.html');
exit;


