<?php
/* -----------------------------------------------------------------------------------------
   $Id: address_book.php,v 1.3 2010/08/05 07:58:49 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(address_book.php,v 1.57 2003/05/29); www.oscommerce.com 
   (c) 2003	 nextcommerce (address_book.php,v 1.14 2003/08/17); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/

include( 'includes/application_top.php');

$smarty = new yesSmarty;
$YesBoxes->load( $smarty, basename(__FILE__) );

// include needed functions
require_once(DIR_FS_INC . 'xtc_address_label.inc.php');
require_once(DIR_FS_INC . 'xtc_get_country_name.inc.php');
require_once(DIR_FS_INC . 'xtc_image_button.inc.php');
require_once(DIR_FS_INC . 'xtc_count_customer_address_book_entries.inc.php');

if (!isset($_SESSION['customer_id'])) {
    xtc_redirect(xtc_href_link(FILENAME_LOGIN, '', 'SSL'));
}


$breadcrumb->add(NAVBAR_TITLE_1_ADDRESS_BOOK, xtc_href_link(FILENAME_ACCOUNT, '', 'SSL'));
$breadcrumb->add(NAVBAR_TITLE_2_ADDRESS_BOOK, xtc_href_link(FILENAME_ADDRESS_BOOK, '', 'SSL'));

require(DIR_WS_INCLUDES . 'header.php');



if ($messageStack->size('addressbook') > 0) {
    $smarty->assign('error',$messageStack->output('addressbook'));
}
$smarty->assign([
    'ADDRESS_DEFAULT'=>xtc_address_label($_SESSION['customer_id'], $_SESSION['customer_default_address_id'], true, ' ', '<br>'),
    'IMAGE_BUTTON_BACK'=>IMAGE_BUTTON_BACK,
    'IMAGE_BUTTON_ADD_ADDRESS'=>IMAGE_BUTTON_ADD_ADDRESS,
]);

$addresses_data=array();

$items = \YES4Trade\Model\address_book::get_by_customers_id((int)$_SESSION['customer_id'],[],'entry_firstname, entry_lastname');
foreach($items as $it){
    $format_id = xtc_get_address_format_id($it->entry_country_id);
    if ($it->address_book_id == $_SESSION['customer_default_address_id']) {
        $primary = 1;
    } else {
        $primary =0;
    }
    $addresses = [];
    $addresses_raw = $it->toArray();
    foreach($addresses_raw as $ak=>$av){
        $addresses[ str_replace('entry_','',$ak) ] = $av;
    }
    $addresses_data[]=array(
        'NAME'=> $it->entry_firstname . ' ' . $it->entry_lastname,
        'BUTTON_EDIT'=> '<a class="ui-button ui-corner-all" href="' . xtc_href_link(FILENAME_ADDRESS_BOOK_PROCESS, 'edit=' . $it->address_book_id, 'SSL') . '">' . SMALL_IMAGE_BUTTON_EDIT . '</a>',
        'BUTTON_DELETE'=> '<a class="ui-button ui-corner-all" href="' . xtc_href_link(FILENAME_ADDRESS_BOOK_PROCESS, 'delete=' . $it->address_book_id, 'SSL') . '">' . SMALL_IMAGE_BUTTON_DELETE . '</a>',
        'ADDRESS'=> xtc_address_format($format_id, $addresses, true, ' ', '<br>'),
        'PRIMARY'=> $primary,
        'INVALID'=>$invalid
    );
}
$smarty->assign('addresses_data',$addresses_data);

$smarty->assign('BUTTON_BACK','<a href="' . xtc_href_link(FILENAME_ACCOUNT, '', 'SSL') . '">' . xtc_image_button('button_back.gif', IMAGE_BUTTON_BACK) . '</a>');

if (xtc_count_customer_address_book_entries() < MAX_ADDRESS_BOOK_ENTRIES) {
    $smarty->assign('BUTTON_NEW','<a href="' . xtc_href_link(FILENAME_ADDRESS_BOOK_PROCESS, '', 'SSL') . '">' . xtc_image_button('button_add_address.gif', IMAGE_BUTTON_ADD_ADDRESS) . '</a>');
}

$smarty->assign('ADDRESS_COUNT',sprintf(TEXT_MAXIMUM_ENTRIES, MAX_ADDRESS_BOOK_ENTRIES));

$smarty->assign('language', $_SESSION['language']);
$smarty->caching = 0;
$main_content=$smarty->fetch(CURRENT_TEMPLATE . '/module/address_book.html');

$smarty->assign('language', $_SESSION['language']);
$smarty->assign('main_content',$main_content);
$smarty->caching = 0;
if (!defined('RM')) {
    $smarty->load_filter('output', 'note');
}
$smarty->display(CURRENT_TEMPLATE . '/index.html');
